<?php

/**
 * Class RatingsController_bwg
 */
class RatingsController_bwg {

  /**
   * @var $model
   */
  private $model;
  /**
   * @var $view
   */
  private $view;
  /**
   * @var string $page
   */
  private $page;
  /**
   * @var string $bulk_action_name
   */
  private $bulk_action_name;
  /**
   * @var int $items_per_page
   */
  private $items_per_page = 20;
  /**
   * @var array $actions
   */
  private $actions = array();

  public function __construct() {
    $this->model = new RatingsModel_bwg();
    $this->view = new RatingsView_bwg();

    $this->page = WDWLibrary::get('page');

    $this->actions = array(
      'delete' => array(
        'title' => __('Delete', BWG()->prefix),
        $this->bulk_action_name => __('deleted', BWG()->prefix),
      ),
    );

    $user = get_current_user_id();
    $screen = get_current_screen();
    $option = $screen->get_option('per_page', 'option');
    $this->items_per_page = get_user_meta($user, $option, true);

    if ( empty ( $this->items_per_page) || $this->items_per_page < 1 ) {
      $this->items_per_page = $screen->get_option( 'per_page', 'default' );
    }
  }

  /**
   * Execute.
   */
  public function execute() {
    $task = WDWLibrary::get('task');
    $id   =  WDWLibrary::get('current_id', 0, 'intval');
    if ( $task != 'display' && method_exists($this, $task) ) {
      if ( $task != 'add' && $task != 'edit' ) {
        check_admin_referer(BWG()->nonce, BWG()->nonce);
      }
      $action = WDWLibrary::get('bulk_action', -1);
      if ( $action != -1 ) {
        $this->bulk_action($action);
      }
      else {
        $this->$task($id);
      }
    }
    else {
      $this->display();
    }
  }

    /**
     * Display.
     */
  public function display() {
		// Set params for view.
		$params = array();
		$params['page'] = $this->page;
		$params['page_title'] = __('Ratings', BWG()->prefix);
		$params['actions'] = $this->actions;
		$params['filters_config'] = $this->filters_config();
		// order
		$params['orderby'] = WDWLibrary::get('orderby', 'date');
		$params['order'] = WDWLibrary::get('order', 'desc');
		// filter
		$params['filterby_gallery'] = WDWLibrary::get('filter-by-gallery');
		$params['filterby_image'] = WDWLibrary::get('filter-by-image');
		// To prevent SQL injections.
		$params['order'] = ($params['order'] == 'desc') ? 'desc' : 'asc';
		if ( !in_array($params['orderby'], array('image_id', 'rate', 'ip', 'date' )) ) {
		  $params['orderby'] = 'id';
		}
		$params['items_per_page'] = $this->items_per_page;
		$page = abs(WDWLibrary::get('paged', 1, 'intval'));
		$page_num = $page ? ($page - 1) * $params['items_per_page'] : 0;
		$params['page_num'] = intval(abs($page_num));
		$params['search'] = WDWLibrary::get('s');
		$data = $this->model->get_rows_data($params);
		$params['total'] = $data['total'];
		$params['rows']  = $data['rows'];
		// set pagination url.
		$url_arg = array();
		(!empty($params['filterby_gallery']) ? $url_arg['filter-by-gallery'] = $params['filterby_gallery'] : '');
		(!empty($params['filterby_image']) ? $url_arg['filter-by-image'] = $params['filterby_image'] : '');
		$page_url = add_query_arg(array(
							'page' => $this->page,
							BWG()->nonce => wp_create_nonce(BWG()->nonce),
						  ), admin_url('admin.php'));

		$page_url = add_query_arg($url_arg, $page_url);
		$params['page_url'] = $page_url;
		$this->view->display($params);
	}

  /**
   * Filters config.
   *
   * @param array $params
   * @return array
   */
	private function filters_config( $params = array() ) {
		$gallery_id = WDWLibrary::get('filter-by-gallery', 0, 'intval');
		$filters = array(
			'filters' => array(
					'gallery' => array(
						'label' => __('Filter by gallery', BWG()->prefix),
						'items' => $this->model->get_galleries()
					),
					'image' => array(
						'label' => __('Filter by image', BWG()->prefix),
						'items' => $this->model->get_images($gallery_id)
					),
				)
			);
		return $filters;
	}
	
	/**
	* Bulk actions.
	*
	* @param $task
	*/
	public function bulk_action($task) {
		$message = 0;
		$successfully_updated = 0;
		$url_arg = array('page' => $this->page,'task' => 'display');

		$check = WDWLibrary::get('check');
		$all = WDWLibrary::get('check_all_items');
		$all = ($all == 'on' ? TRUE : FALSE);

		if ( method_exists($this, $task) ) {
			if ( $all ) {
				$message = $this->$task(0, TRUE, TRUE);
				$url_arg['message'] = $message;
			}
			else {
				if ( $check ) {
						foreach ( $check as $form_id => $item ) {
						  $message = $this->$task($form_id, TRUE);
						  if ( $message != 2 ) {
							// Increase successfully updated items count, if action doesn't failed.
							$successfully_updated++;
						  }
						}
					}
			}
			if ( $successfully_updated ) {
				$bulk_action = $this->bulk_action_name;
				$message = sprintf(_n('%s item successfully %s.', '%s items successfully %s.', $successfully_updated, BWG()->prefix), $successfully_updated, $this->actions[$task][$bulk_action]);
			}
			$key = ($message === 2 ? 'message' : 'msg');
			$url_arg[$key] = $message;
		}

		WDWLibrary::redirect( add_query_arg( $url_arg , admin_url('admin.php') ) );

	}

	/**
	* Delete form by id.
	*
	* @param      $id
	* @param bool $bulk
	* @param bool $all
	*
	* @return int
	*/
	public function delete( $id, $bulk = FALSE, $all = FALSE ) {
		$message_id = $this->model->delete($id, $all);
		if ( $bulk ) {
		  return $message_id;
		}
		WDWLibrary::redirect( add_query_arg( array('page' => $this->page, 'task' => 'display', 'message_id' => $message_id), admin_url('admin.php') ) );
	}
}