<?php

/**
 * Class CommentsModel_bwg
 */
class CommentsModel_bwg {
  /**
   * Get rows data or total count.
   *
   * @param      $params
   * @param bool $total
   *
   * @return array|null|object|string
   */
  public function get_rows_data( $params, $total = FALSE ) {
    global $wpdb;
    $order = $params['order'];
    $orderby = $params['orderby'];
    $page_per = $params['items_per_page'];
    $page_num = $params['page_num'];
    $search = $params['search'];
    $prepareArgs = array();

    if ( !$total ) {
      $query = 'SELECT t1.*, t2.thumb_url, t2.alt, t2.filetype';
    }
    else {
      $query = 'SELECT COUNT(*)';
    }
    $query .= ' FROM `' . $wpdb->prefix . 'bwg_image_comment` AS `t1`';
    $query .= ' INNER JOIN `' . $wpdb->prefix . 'bwg_image` as t2 on t1.image_id=t2.id';
    $query .= ' WHERE 1';
    if ( $search ) {
      $query .= ' AND `t1`.`name` LIKE %s OR `t1`.`comment` LIKE %s OR `t1`.`mail` LIKE %s';
      $prepareArgs[] = "%" . $search . "%";
      $prepareArgs[] = "%" . $search . "%";
      $prepareArgs[] = "%" . $search . "%";
    }

    $filter_by_gallery = WDWLibrary::get('filter-by-gallery', 0, 'intval');
    $filter_by_image = WDWLibrary::get('filter-by-image', 0, 'intval');
    if ( $filter_by_gallery ) {
      $query .= ' AND `t2`.`gallery_id`=%d';
      $prepareArgs[] = $filter_by_gallery;
    }
    if ( $filter_by_image ) {
      $query .= ' AND `t1`.`image_id`=%d';
      $prepareArgs[] = $filter_by_image;
    }
    if ( !$total ) {
      $query .= ' ORDER BY `t1`.`' . $orderby . '` ' . $order;
      $query .= ' LIMIT %d,%d';
      $prepareArgs[] = $page_num;
      $prepareArgs[] = $page_per;
    }
    if ( !$total ) {
      $rows = $wpdb->get_results($wpdb->prepare($query, $prepareArgs));
    }
    else {
      if( !empty($prepareArgs) ) {
          $rows = $wpdb->get_var($wpdb->prepare($query, $prepareArgs));
      } else {
          $rows = $wpdb->get_var($query);
      }
    }

    return $rows;
  }

  public function get_galleries() {
    global $wpdb;
    $rows_object = $wpdb->get_results("SELECT * FROM `" . $wpdb->prefix . "bwg_gallery` WHERE published=1");
    $rows[0] = __('All galleries', BWG()->prefix);
    if ( $rows_object ) {
      foreach ( $rows_object as $row_object ) {
        $rows[$row_object->id] = $row_object->name;
      }
    }

    return $rows;
  }

  public function get_images($gal_id) {
    global $wpdb;
    $prepareArgs = array(1);
    $where = '';
    if ( $gal_id ) {
      $where = ' AND gallery_id=%d';
      $prepareArgs[] = $gal_id;
    }
    $rows_object = $wpdb->get_results($wpdb->prepare("SELECT * FROM `" . $wpdb->prefix . "bwg_image` WHERE published=%d" . $where, $prepareArgs));
    $rows[0] = __('All images', BWG()->prefix);
    if ( $rows_object ) {
      foreach ( $rows_object as $row_object ) {
        $rows[$row_object->id] = $row_object->filename;
      }
    }
    return $rows;
  }

  /**
   * Return total count of themes.
   *
   * @param $params
   *
   * @return array|null|object|string
   */
  public function total($params) {
    return $this->get_rows_data($params, TRUE);
  }
}
