<?php

/**
 * Class RatingsModel_bwg
 */
class RatingsModel_bwg {

	/**
	* Get rows data or total count.
	*
	* @param      $params
	*
	* @return array|null|object|string
	*/
	public function get_rows_data( $params ) {
		global $wpdb;
		extract($params);
    $prepareArgs = array();
		$where  = '';
		if ( !empty($filterby_gallery) ) {
      $where .= '`t2`.`gallery_id` = %d AND ';
      $prepareArgs[] = (int) $filterby_gallery;
    }
    if ( !empty($filterby_image) ) {
      $where .= '`t1`.`image_id` = %d AND ';
      $prepareArgs[] = $filterby_image;
    }

    if ( !empty($search) ) {
      $where .= ' `t1`.`ip` LIKE %s AND ';
      $prepareArgs[] = "%" . $search . "%";
    }

		$where  = rtrim($where , ' AND ');

		$query  = ' SELECT `t1`.*, `t2`.`thumb_url`, `t2`.`alt`, `t2`.`filetype`';
		$q1  	= ' FROM `' . $wpdb->prefix . 'bwg_image_rate` AS `t1`
					INNER JOIN `' . $wpdb->prefix . 'bwg_image` AS `t2`
					ON (`t1`.`image_id` = `t2`.`id`)
					'. ( ( $where ) ? 'WHERE '. $where : '' );
    $total_query = 'SELECT COUNT(*) AS `qty` '. $q1;
    if($where) {
        $data['total'] = $wpdb->get_var($wpdb->prepare($total_query,$prepareArgs));
    } else {
        $data['total'] = $wpdb->get_var($total_query);
    }

    $query .= $q1 . ' ORDER BY `t1`.`' . $orderby . '` ' . $order;
		$query .= ' LIMIT %d,%d';
    $prepareArgs[] = $page_num;
    $prepareArgs[] = $items_per_page;
    $data['rows'] = $wpdb->get_results($wpdb->prepare($query, $prepareArgs));
		return $data;
	}

    /**
     * Delete.
     *
     * @param $id
     * @param bool $all
     * @return int
     */
	public function delete( $id, $all = false ) {
		global $wpdb;
		$message_id = 2;
		// Delete all itmes.
		if ( !$id && $all ) {
			$delete = $wpdb->query('DELETE FROM `' . $wpdb->prefix . 'bwg_image_rate`');
			if ( $delete ) {
				$update = $wpdb->query('UPDATE '. $wpdb->prefix . 'bwg_image SET `avg_rating` = "0", `rate_count` = "0"');
				if ( $update ) {
					$message_id = 5;
				}
			}
		}
		else {
			// Delete itme by id.
			$image_id = $wpdb->get_var($wpdb->prepare('SELECT `image_id` FROM `' . $wpdb->prefix . 'bwg_image_rate` WHERE `id`="%d"', $id));
			$query = $wpdb->prepare('DELETE FROM `' . $wpdb->prefix . 'bwg_image_rate` WHERE `id`="%d"', $id);
			if ( $wpdb->query($query) ) {
				$rates = $wpdb->get_row($wpdb->prepare('SELECT AVG(`rate`) as `average`, COUNT(`rate`) as `rate_count` FROM ' . $wpdb->prefix . 'bwg_image_rate WHERE image_id="%d"', $image_id));
				$update = $wpdb->update($wpdb->prefix . 'bwg_image',
                                array('avg_rating' => $rates->average, 'rate_count' => $rates->rate_count),
                                array('id' => $image_id),
                                array('%f','%d'),
                                array('%d')
        );
				if ( $update ) {
					$message_id = 3;
				}
			}
		}
		return $message_id;
	}

    /**
     * Get galleries.
     *
     * @return array $rows
     */
	public function get_galleries() {
		global $wpdb;
		$rows_object = $wpdb->get_results("SELECT * FROM " . $wpdb->prefix . "bwg_gallery WHERE published=1");
		$rows[0] = __('All galleries', BWG()->prefix);
		if ($rows_object) {
		  foreach ($rows_object as $row_object) {
			$rows[$row_object->id] = $row_object->name;
		  }
		}
		return $rows;
	}

    /**
     * Get images.
     *
     * @param int $gallery_id
     * @return array $rows
     */
	public function get_images( $gallery_id = 0 ) {
		global $wpdb;

    $prepareArgs = array();
    $where = '';
		if( $gallery_id ) {
      $where = ' AND gallery_id=%d';
      $prepareArgs[] = $gallery_id;
    }
    if( !empty($prepareArgs) ) {
        $rows_object = $wpdb->get_results($wpdb->prepare("SELECT * FROM " . $wpdb->prefix . "bwg_image WHERE published=1" . $where, $prepareArgs));
    } else {
        $rows_object = $wpdb->get_results("SELECT * FROM " . $wpdb->prefix . "bwg_image WHERE published=1" . $where);
    }
		$rows[0] = __('All images', BWG()->prefix);
		if ($rows_object) {
		  foreach ($rows_object as $row_object) {
			  $rows[$row_object->id] = $row_object->alt;
		  }
		}
		return $rows;
	}
}