<?php

/**
 * Class CommentsView_bwg
 */
class CommentsView_bwg extends AdminView_bwg {
  /**
   * Display page.
   *
   * @param $params
   */
  public function display( $params = array() ) {
    ob_start();
    echo $this->body($params);
    // Pass the content to form.
    $form_attr = array(
      'id' => BWG()->prefix . '_comments',
      'name' => BWG()->prefix . '_comments',
      'class' => BWG()->prefix . '_comments wd-form',
      'action' => add_query_arg(array( 'page' => 'comments_' . BWG()->prefix ), 'admin.php'),
    );
    echo $this->form(ob_get_clean(), $form_attr);
  }

  /**
   * Generate page body.
   *
   * @param $params
   */
  public function body( $params = array() ) {
    $order = $params['order'];
    $orderby = $params['orderby'];
    $actions = $params['actions'];
    $filters_config = $params['filters_config'];
    $page = $params['page'];
    $total = $params['total'];
    $items_per_page = $params['items_per_page'];
    $rows_data = $params['rows_data'];
    $page_url = add_query_arg(array(
                                'page' => $page,
                                BWG()->nonce => wp_create_nonce(BWG()->nonce),
                              ), admin_url('admin.php'));
    echo $this->title(array(
                        'title' => $params['page_title'],
                        'title_class' => 'wd-header',
                        'add_new_button' => FALSE,
                      ));
    ?>
    <div class="ajax-msg wd-hide">
    </div>
    <?php
    echo $this->search();
    ?>
  <div class="tablenav top">
      <?php
      echo $this->bulk_actions($actions, TRUE);
      echo $this->filters($filters_config);
      echo $this->pagination($page_url, $total, $items_per_page);
      ?>
    </div>
    <table class="adminlist table table-striped wp-list-table widefat fixed pages media">
      <thead>
      <tr>
        <td id="cb" class="column-cb check-column">
          <label class="screen-reader-text" for="cb-select-all-1"><?php _e('Select all', BWG()->prefix); ?></label>
          <input id="check_all" type="checkbox" />
        </td>
        <?php
        echo WDWLibrary::ordering('name', $orderby, $order, __('Name', BWG()->prefix), $page_url, 'column-primary column-comment-author');
        echo WDWLibrary::ordering('mail', $orderby, $order, __('Email', BWG()->prefix), $page_url, '');
        echo WDWLibrary::ordering('comment', $orderby, $order, __('Comment', BWG()->prefix), $page_url, '');
        echo WDWLibrary::ordering('date', $orderby, $order, __('Date', BWG()->prefix), $page_url);
        ?>
      </tr>
      </thead>
      <tbody>
      <?php
      if ( $rows_data ) {
        foreach ( $rows_data as $row_data ) {
          $alternate = (!isset($alternate) || $alternate == '') ? 'class="alternate"' : '';

          $is_embed = preg_match('/EMBED/', $row_data->filetype) == 1 ? TRUE : FALSE;
          $publish_url = add_query_arg(array('task' => ($row_data->published ? 'unpublish' : 'publish'), 'current_id' => $row_data->id), $page_url);
          $delete_url = add_query_arg(array( 'task' => 'delete', 'current_id' => $row_data->id ), $page_url);
          ?>
          <tr id="tr_<?php echo $row_data->id; ?>" <?php echo $alternate; ?>>
            <th class="check-column">
              <input id="check_<?php echo $row_data->id; ?>" name="check[<?php echo $row_data->id; ?>]" type="checkbox" onclick="spider_check_all(this)" />
            </th>
            <td class="column-primary column-title column-comment-author" data-colname="<?php _e('Name', BWG()->prefix); ?>">
              <strong class="has-media-icon">
                <a>
                  <span class="media-icon image-icon">
                    <img class="preview-image" title="<?php echo $row_data->alt; ?>" src="<?php echo (!$is_embed ? BWG()->upload_url : "") . $row_data->thumb_url; ?>" width="60" height="60" />
                  </span>
                  <?php echo $row_data->name; ?>
                </a>
                <?php
                if ( !$row_data->published ) {
                  ?>
                  —
                  <span class="post-state"><?php _e('Unpublished', BWG()->prefix); ?></span>
                  <?php
                }
                ?>
              </strong>
              <div class="row-actions">
                <span>
                  <a href="<?php echo $publish_url; ?>"><?php echo ($row_data->published ? __('Unpublish', BWG()->prefix) : __('Publish', BWG()->prefix)); ?></a>
                  |
                </span>
                <span class="trash"><a onclick="if (!confirm('<?php echo addslashes(__('Do you want to delete selected item?', BWG()->prefix)); ?>')) {return false;}" href="<?php echo $delete_url; ?>"><?php _e('Delete', BWG()->prefix); ?></a></span>
              </div>
              <button class="toggle-row" type="button">
                <span class="screen-reader-text"><?php _e('Show more details', BWG()->prefix); ?></span>
              </button>
            </td>
            <td data-colname="<?php _e('Email', BWG()->prefix); ?>">
              <?php echo $row_data->mail; ?>
            </td>
            <td data-colname="<?php _e('Comment', BWG()->prefix); ?>">
              <?php echo $row_data->comment; ?>
            </td>
            <td data-colname="<?php _e('Date', BWG()->prefix); ?>"><?php echo $row_data->date; ?></td>
          </tr>
          <?php
        }
      }
      else {
        echo WDWLibrary::no_items('comments', 4);
      }
      ?>
      </tbody>
    </table>
    <div class="tablenav bottom">
      <?php echo $this->pagination($page_url, $total, $items_per_page); ?>
    </div>
    <?php
  }
}
