<?php
/**
 * Class RatingsView_bwg
 */
class RatingsView_bwg extends AdminView_bwg {
   /**
   * Display page.
   *
   * @param $params
   */
	public function display( $params = array() ) {
		ob_start();
		echo $this->body($params);
		// Pass the content to form.
		$form_attr = array(
		  'id' => BWG()->prefix . '_ratings',
		  'name' => BWG()->prefix . '_ratings',
		  'class' => BWG()->prefix . '_ratings wd-form',
		  'action' => add_query_arg(array( 'page' => 'ratings_' . BWG()->prefix ), 'admin.php'),
		  'task' => 'filters'
		);
		echo $this->form(ob_get_clean(), $form_attr);
	}

	/**
	* Generate page body.
	*
	* @param $params
	*/
	public function body( $params = array() ) {
		extract($params);


		echo $this->title( array(
							'title' => $page_title,
							'title_class' => 'wd-header',
						  )
						);
		echo $this->search( array(
								'search_item_name' => __('IP', BWG()->prefix)
							)
						);
		?>
		<div class="tablenav top">
		<?php
			echo $this->bulk_actions($actions, TRUE);
			echo $this->filters($filters_config);
			echo $this->pagination($page_url, $total, $items_per_page);
		?>
		</div>
		<table class="adminlist table table-striped wp-list-table widefat fixed pages media">
			<thead>
				<td id="cb" class="column-cb check-column">
				  <label class="screen-reader-text" for="cb-select-all-1">Select all</label>
					<input id="check_all" type="checkbox">
				</td>
				<?php echo WDWLibrary::ordering('image', $orderby, $order, __('Image', BWG()->prefix), $page_url, 'column-primary column-comment-author'); ?>
				<?php echo WDWLibrary::ordering('rate', $orderby, $order, __('Rating', BWG()->prefix), $page_url); ?>
				<?php echo WDWLibrary::ordering('ip', $orderby, $order, __('IP', BWG()->prefix), $page_url); ?>
				<?php echo WDWLibrary::ordering('date', $orderby, $order, __('Date', BWG()->prefix), $page_url); ?>
			</thead>
			<tbody>
			<?php
      if ( $rows ) {
				foreach ($rows as $row) {
					$alternate = (!isset($alternate) || $alternate == '') ? 'class="alternate"' : '';
					$is_embed = preg_match('/EMBED/',$row->filetype)==1 ? true :false;
					$delete_url = add_query_arg(array( 'task' => 'delete', 'current_id' => $row->id ), $page_url);
				  ?>
					<tr id="tr_<?php echo $row->id; ?>" <?php echo $alternate; ?>>
						<th class="check-column">
							<input type="checkbox" id="check_<?php echo $row->id; ?>" name="check[<?php echo $row->id; ?>]" onclick="spider_check_all(this)" />
						</th>
						<td class="column-primary column-title column-comment-author" data-colname="<?php _e('Image', BWG()->prefix); ?>">
							<strong class="has-media-icon">
								<a href="">
								  <span class="media-icon image-icon">
									<img class="preview-image" title="<?php echo $row->alt; ?>" src="<?php echo (!$is_embed ? BWG()->upload_url : "") . $row->thumb_url; ?>" width="60" height="60" />
								  </span>
								  <?php echo $row->alt; ?>
								</a>
							</strong>
							<div class="row-actions">
								<span class="trash"><a onclick="if (!confirm('<?php echo addslashes(__('Do you want to delete selected item?', BWG()->prefix)); ?>')) {return false;}" href="<?php echo $delete_url; ?>"><?php _e('Delete', BWG()->prefix); ?></a></span>
							</div>
							<button class="toggle-row" type="button">
								<span class="screen-reader-text"><?php _e('Show more details', BWG()->prefix); ?></span>
							</button>
						</td>
						<td data-colname="<?php _e('Rating', BWG()->prefix); ?>"><?php echo $row->rate; ?></td>
						<td data-colname="<?php _e('IP', BWG()->prefix); ?>"><?php echo $row->ip; ?></td>
						<td data-colname="<?php _e('Date', BWG()->prefix); ?>"><?php echo $row->date; ?></td>
					</tr>
				<?php
				}
			}
			else {
				echo WDWLibrary::no_items('ratings', 5);
			}
			?>
			</tbody>
		</table>
		<div class="tablenav bottom">
			<?php echo $this->pagination($page_url, $total, $items_per_page); ?>
		</div>
	<?php 
  }
}