<?php
$bwg_initial_version = get_option( 'wd_bwg_initial_version' );
if( !get_option( 'bwg_sr_asked_permission' ) && $bwg_initial_version && ( version_compare( $bwg_initial_version, '1.5.57', '>=' ) ) ) {
  add_action( 'bwg_admin_view_form_after', 'bwg_sr_popup' );
}

add_action( 'bwg_uninstall_after', 'bwg_sr_uninstall' );
function bwg_sr_uninstall() {
  delete_option('bwg_sr_asked_permission');
  delete_transient('bwg_sr_provided_permission');
}

function bwg_sr_popup() {
  ob_start();
  ?>
  <link href="https://fonts.googleapis.com/css2?family=Open+Sans:wght@300;400;800&display=swap" rel="stylesheet">
  <style>

    * {
      margin: 0;
      padding: 0;
      list-style: none;
      text-decoration: none;
      color: inherit;
    }

    .bwg_pp h2 {
      padding: 0 !important;
    }

    .bwg_pp p {
      margin: 0;
    }

    .bwg_pp_wrapper .heading {
      margin-bottom: 0px;
    }

    #permision-popup {
      display: -webkit-box;
      display: -webkit-flex;
      display: -ms-flexbox;
      display: flex;
      -webkit-box-align: center;
      -webkit-align-items: center;
      -ms-flex-align: center;
      align-items: center;
      min-height: 477px;
      position: absolute;
      top: -webkit-calc(50% - 239px);
      top: calc(50% - 239px);
      left: -webkit-calc(50% - 239px);
      left: calc(50% - 239px);
    }

    .bwg_pp .bwg_pp_overlay {
      background: #323A45;
      opacity: .7;
      position: fixed;
      top: 0;
      right: 0;
      height: 100vh;
      width: 100vw;
      z-index: 10010;
    }

    .bwg_pp .bwg_pp_wrapper_fullpage {
      width: 100vw;
      height: 100vh;
      top: 0;
      left: 0;
      display: -webkit-box;
      display: -webkit-flex;
      display: -ms-flexbox;
      display: flex;
      -webkit-box-pack: center;
      -webkit-justify-content: center;
      -ms-flex-pack: center;
      justify-content: center;
      -webkit-box-align: center;
      -webkit-align-items: center;
      -ms-flex-align: center;
      align-items: center;
      z-index: 10030;
      position: fixed;
      overflow-y: scroll;
    }

    .bwg_pp .bwg_pp_wrapper_fullpage .bwg_pp_wrapper {
      z-index: 10021;
      position: relative;
      background: #FFFFFF 0% 0% no-repeat padding-box;
      border: 0.5px solid #00000026;
      border-radius: 15px;
      display: -webkit-box;
      display: -webkit-flex;
      display: -ms-flexbox;
      display: flex;
      -webkit-box-orient: vertical;
      -webkit-box-direction: normal;
      -webkit-flex-direction: column;
      -ms-flex-direction: column;
      flex-direction: column;
      -webkit-box-align: center;
      -webkit-align-items: center;
      -ms-flex-align: center;
      align-items: center;
    }

    .bwg_pp .bwg_pp_wrapper_fullpage .bwg_pp_wrapper .close-btn {
      background: url(<?php echo BWG()->plugin_url . "/images/dataCollecting/Group76663.svg"?>);
      height: 16px;
      width: 16px;
      position: absolute;
      top: 10px;
      right: 10px;
      outline: none;
      border: none;
      cursor: pointer;
    }

    .bwg_pp .bwg_pp_wrapper_fullpage .bwg_pp_wrapper .heading {
      text-align: center;
      font-family: 'Open Sans', sans-serif;
      font-weight: 900;
      color: #323A45;
    }

    .bwg_pp .bwg_pp_wrapper_fullpage .bwg_pp_wrapper .heading .smile {
      display: inline-block;
      background-color: transparent;
      background-repeat: no-repeat;
      background-size: contain;
      position: relative;
      top: 1px;
      opacity: 1;
      vertical-align: baseline;
    }

    .bwg_pp .bwg_pp_wrapper_fullpage .bwg_pp_wrapper p.text {
      letter-spacing: 0;
      text-align: center;
      font-family: 'Open Sans', sans-serif;
      font-weight: 300;
      white-space: nowrap;
    }

    .bwg_pp .bwg_pp_wrapper_fullpage .bwg_pp_wrapper p.text strong {
      font-size: 16px;
      color: #323A45;
      font-weight: 700;
      border-bottom: 0.5px solid #00000026;
      position: relative;
      cursor: pointer;
    }

    .bwg_pp .bwg_pp_wrapper_fullpage .bwg_pp_wrapper p.text strong:hover .bwg-popup {
      display: block;
    }

    .bwg_pp .bwg_pp_wrapper_fullpage .bwg_pp_wrapper p.text strong .bwg-popup {
      display: none;
      box-sizing: border-box;
      position: absolute;
      left: 0;
      width: 298px;
      padding: 15px 20px;
      background: transparent linear-gradient(180deg, #FFFFFF 0%, #FFFFFF 100%) 0% 0% no-repeat padding-box;
      box-shadow: 0px 5px 16px #E5E6E8;
      border: 1px solid #0000000F;
      border-radius: 10px;
      opacity: 1;
      margin-top: 13px;
      text-align: left;
    }

    .bwg_pp .bwg_pp_wrapper_fullpage .bwg_pp_wrapper p.text strong .bwg-popup .bwg-popup-head {
      font-size: 14px;
      font-weight: 800;
      line-height: 19px;
      letter-spacing: 0px;
      color: #323A45;
      opacity: 1;
    }

    .bwg_pp .bwg_pp_wrapper_fullpage .bwg_pp_wrapper p.text strong .bwg-popup .bwg-popup-text {
      font-size: 14px;
      font-weight: 500;
      line-height: 19px;
      letter-spacing: 0px;
      color: #323A45;
      opacity: 1;
    }

    .bwg_pp .bwg_pp_wrapper_fullpage .bwg_pp_wrapper .access {
      cursor: pointer;
      display: block;
      background-color: #23B536;
      color: #ffffff;
      text-align: center;
      font-family: 'Segoe UI', sans-serif;
      font-weight: 600;
      letter-spacing: 0px;
      color: #FFFFFF;
      opacity: 1;
      border-radius: 4px;
      border: #23B536;
      outline: none;
    }

    .bwg_pp .bwg_pp_wrapper_fullpage .bwg_pp_wrapper .access:hover {
      background-color: #1E9C2E;
    }

    .bwg_pp .bwg_pp_wrapper_fullpage .bwg_pp_wrapper .data-share {
      display: block;
      text-align: center;
      font-family: 'Open Sans', sans-serif;
      font-weight: 400;
      letter-spacing: 0px;
      color: #323A45;
      opacity: 1;
      border-bottom: 1px solid #DEDEDE;
      width: -webkit-fit-content;
      width: -moz-fit-content;
      width: fit-content;
    }

    .bwg_pp .bwg_pp_wrapper_fullpage .bwg_pp_wrapper .data-share:hover {
      border-bottom: 1px solid #C4C4C4;
    }

    .bwg_pp .bwg_pp_wrapper_fullpage .bwg_pp_wrapper .privacy-policy {
      display: block;
      text-align: center;
      font-family: 'Open Sans', sans-serif;
      font-weight: 400;
      letter-spacing: 0px;
      color: #323A45;
      opacity: 1;
      border-bottom: 1px solid #DEDEDE;
      width: auto;
      width: -webkit-fit-content;
      width: -moz-fit-content;
      width: fit-content;
    }

    .bwg_pp .bwg_pp_wrapper_fullpage .bwg_pp_wrapper .privacy-policy:hover {
      border-bottom: 1px solid #C4C4C4;
    }

    .br-mobile {
      display: none;
    }

    @media only screen and (min-width: 1920px) {
      .bwg_pp_wrapper {
        width: 692px;
        margin: 327px auto auto;
        margin: 0 auto;
        display: -webkit-box;
        display: -webkit-flex;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-orient: vertical;
        -webkit-box-direction: normal;
        -webkit-flex-direction: column;
        -ms-flex-direction: column;
        flex-direction: column;
        -webkit-box-align: center;
        -webkit-align-items: center;
        -ms-flex-align: center;
        align-items: center;
      }

      .bwg_pp_wrapper .heading {
        font-size: 30px;
        line-height: 41px;
        margin-top: 50px;
      }

      .bwg_pp_wrapper .heading .smile {
        width: 24px;
        height: 24px;
        background-image: url(<?php echo BWG()->plugin_url . "/images/dataCollecting/slightly-smiling-face_1f642@2x.png"?>);
        content: "";
      }

      .bwg_pp_wrapper p.text {
        margin-top: 14px;
        width: 622px;
        font-size: 16px;
        line-height: 26px;
      }

      .bwg_pp_wrapper .access {
        width: 182px;
        height: 41px;
        font-size: 16px;
        line-height: 21px;
        margin-top: 30px;
      }

      .bwg_pp_wrapper .data-share {
        width: auto;
        width: -webkit-fit-content;
        width: -moz-fit-content;
        width: fit-content;
        height: 19px;
        margin-top: 18px;
        font-size: 14px;
        line-height: 19px;
      }

      .bwg_pp_wrapper .privacy-policy {
        width: 88px;
        height: 19px;
        margin-top: 30px;
        margin-bottom: 20px;
        font-size: 14px;
        line-height: 19px;
      }
    }

    @media only screen and (min-width: 1366px) and (max-width: 1920px) {
      .bwg_pp_wrapper {
        width: 692px;
        margin: 179px auto auto;
        margin: 0 auto;
        display: -webkit-box;
        display: -webkit-flex;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-orient: vertical;
        -webkit-box-direction: normal;
        -webkit-flex-direction: column;
        -ms-flex-direction: column;
        flex-direction: column;
        -webkit-box-align: center;
        -webkit-align-items: center;
        -ms-flex-align: center;
        align-items: center;
      }

      .bwg_pp_wrapper .heading {
        font-size: 30px;
        line-height: 41px;
        margin-top: 50px;
      }

      .bwg_pp_wrapper .heading .smile {
        width: 24px;
        height: 24px;
        background-image: url(<?php echo BWG()->plugin_url . "/images/dataCollecting/slightly-smiling-face_1f642@2x.png" ?>);
        content: "";
      }

      .bwg_pp_wrapper p.text {
        margin-top: 14px;
        width: 622px;
        font-size: 16px;
        line-height: 26px;
      }

      .bwg_pp_wrapper .access {
        width: 182px;
        height: 41px;
        font-size: 16px;
        line-height: 21px;
        margin-top: 30px;
      }

      .bwg_pp_wrapper .data-share {
        width: auto;
        width: -webkit-fit-content;
        width: -moz-fit-content;
        width: fit-content;
        height: 19px;
        margin-top: 18px;
        font-size: 14px;
        line-height: 19px;
      }

      .bwg_pp_wrapper .privacy-policy {
        width: 88px;
        height: 19px;
        margin-top: 30px;
        margin-bottom: 20px;
        font-size: 14px;
        line-height: 19px;
      }
    }

    @media only screen and (min-width: 1280px) and (max-width: 1365px) {
      .bwg_pp_wrapper {
        width: 692px;
        margin: 231px auto auto;
        margin: 0 auto;
        display: -webkit-box;
        display: -webkit-flex;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-orient: vertical;
        -webkit-box-direction: normal;
        -webkit-flex-direction: column;
        -ms-flex-direction: column;
        flex-direction: column;
        -webkit-box-align: center;
        -webkit-align-items: center;
        -ms-flex-align: center;
        align-items: center;
      }

      .bwg_pp_wrapper .heading {
        font-size: 30px;
        line-height: 41px;
        margin-top: 50px;
      }

      .bwg_pp_wrapper .heading .smile {
        width: 24px;
        height: 24px;
        background-image: url(<?php echo BWG()->plugin_url . "/images/dataCollecting/slightly-smiling-face_1f642@2x.png"?>);
        content: "";
      }

      .bwg_pp_wrapper p.text {
        margin-top: 14px;
        width: 622px;
        height: 100px;
        font-size: 16px;
        line-height: 26px;
      }

      .bwg_pp_wrapper .access {
        width: 182px;
        height: 41px;
        font-size: 16px;
        line-height: 21px;
        margin-top: 30px;
      }

      .bwg_pp_wrapper .data-share {
        width: auto;
        width: auto;
        width: -webkit-fit-content;
        width: -moz-fit-content;
        width: fit-content;
        height: 19px;
        margin-top: 18px;
        font-size: 14px;
        line-height: 19px;
      }

      .bwg_pp_wrapper .privacy-policy {
        width: 88px;
        height: 19px;
        margin-top: 30px;
        margin-bottom: 20px;
        font-size: 14px;
        line-height: 19px;
      }
    }

    @media only screen and (min-width: 767px) and (max-width: 1280px) {
      .bwg_pp_wrapper {
        width: 692px;
        margin: 299px auto auto;
        margin: 0 auto;
        display: -webkit-box;
        display: -webkit-flex;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-orient: vertical;
        -webkit-box-direction: normal;
        -webkit-flex-direction: column;
        -ms-flex-direction: column;
        flex-direction: column;
        -webkit-box-align: center;
        -webkit-align-items: center;
        -ms-flex-align: center;
        align-items: center;
      }

      .bwg_pp_wrapper .heading {
        font-size: 30px;
        line-height: 41px;
        margin-top: 50px;
      }

      .bwg_pp_wrapper .heading .smile {
        width: 24px;
        height: 24px;
        background-image: url(<?php echo BWG()->plugin_url ."/images/dataCollecting/slightly-smiling-face_1f642@2x.png" ?>);
        content: "";
      }

      .bwg_pp_wrapper p.text {
        margin-top: 10px;
        width: 622px;
        height: 100px;
        font-size: 16px;
        line-height: 26px;
      }

      .bwg_pp_wrapper .access {
        width: 182px;
        height: 41px;
        font-size: 16px;
        line-height: 21px;
        margin-top: 30px;
      }

      .bwg_pp_wrapper .data-share {
        width: auto;
        width: -webkit-fit-content;
        width: -moz-fit-content;
        width: fit-content;
        height: 19px;
        margin-top: 20px;
        font-size: 14px;
        line-height: 19px;
      }

      .bwg_pp_wrapper .privacy-policy {
        width: 88px;
        height: 19px;
        margin-top: 30px;
        margin-bottom: 23px;
        font-size: 14px;
        line-height: 19px;
      }
    }

    @media only screen and (min-width: 320px) and (max-width: 766px) {
      .bwg_pp_wrapper {
        width: 300px;
        margin: 38px auto auto;
        margin: 0 auto;
        display: -webkit-box;
        display: -webkit-flex;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-orient: vertical;
        -webkit-box-direction: normal;
        -webkit-flex-direction: column;
        -ms-flex-direction: column;
        flex-direction: column;
        -webkit-box-align: center;
        -webkit-align-items: center;
        -ms-flex-align: center;
        align-items: center;
      }

      .bwg_pp_wrapper .heading {
        font-size: 18px;
        line-height: 24px;
        margin-top: 30px;
      }

      .bwg_pp_wrapper .heading .smile {
        width: 17px;
        height: 17px;
        background-image: url(<?php echo BWG()->plugin_url . '/images/dataCollecting/slightly-smiling-face_1f642.png' ?>);
        content: "";
      }

      .bwg_pp_wrapper p.text {
        margin-top: 10px;
        width: 260px;
        height: 174px;
        font-size: 15px;
        line-height: 22px;
      }

      .bwg_pp .bwg_pp_wrapper_fullpage .bwg_pp_wrapper p.text strong {
        position: static;
      }
      .bwg_pp .bwg_pp_wrapper_fullpage .bwg_pp_wrapper p.text strong:hover .bwg-popup {
        display: block;
      }

      .bwg_pp .bwg_pp_wrapper_fullpage .bwg_pp_wrapper p.text strong .bwg-popup {
        left: calc(50% - 124px);
        width: 248px;
      }

      .bwg_pp_wrapper .access {
        margin-top: 30px;
        width: 260px;
        height: 41px;
        font-size: 14px;
        line-height: 26px;
      }

      .bwg_pp_wrapper .data-share {
        margin-top: 20px;
        font-size: 14px;
        height: 19px;
      }

      .bwg_pp_wrapper .privacy-policy {
        margin-top: 30px;
        margin-bottom: 23px;
        font-size: 14px;
        height: 19px;
      }

      .br-desktop {
        display: none;
      }

      .br-mobile {
        display: inline;
      }
    }
  </style>
  <div class="bwg_pp wrap" id="permision-popup">
    <div class="bwg_pp_overlay">
    </div>
    <div class="bwg_pp_wrapper_fullpage">
      <div class="bwg_pp_wrapper" id="wrapper">
        <button class="close-btn reject" id="close-btn"></button>
        <h2 class="heading">
          Help us make <br class="br-desktop">Photo Gallery <br class="br-mobile"> even better <span class="smile"></span>
        </h2>
        <p class="text">
          10Web would like to collect data<br class="br-mobile"> about how you use the Photo Gallery<br class="br-mobile"> plugin.<br class="br-desktop">
          This will help us improve the<br class="br-mobile"> plugin for you and millions of our<br class="br-mobile"> users.<br class="br-desktop">
          Your data will not be shared<br class="br-mobile"> with third parties and will be deleted<br class="br-mobile"> after 30 days.<br class="br-desktop">
          You can <strong>revoke<span class="bwg-popup"> <span class="bwg-popup-head">Stop Sharing Anytime</span><br><span class="bwg-popup-text">From your WP dashboard go to:<br class="br-desktop"><br class="br-mobile"> Global Settings > General > <br class="br-mobile">New Option</span></span></strong> your<br class="br-mobile"> consent anytime you want.
        </p>
        <button id="access" class="access">OK</button>
        <a class="data-share reject" href="#">Don't collect my data</a>
        <a class="privacy-policy" href="https://10web.io/privacy-policy/" target="_blank">Privacy Policy</a>
      </div>
    </div>
  </div>
  <script>
    var bwg_sr_ajaxurl = "<?php echo add_query_arg(array('action' => 'bwg_sr_data_collecting'), admin_url('admin-ajax.php')); ?>";
    jQuery(function($) {
      jQuery('#access').click(function() {
        let data = {
          'accepted': 1
        }
        jQuery.post( bwg_sr_ajaxurl, data, function() {
          jQuery('#permision-popup').remove();
        });
        return false;
      })
      jQuery('.reject').click(function() {
        jQuery.post( bwg_sr_ajaxurl, function() {
          jQuery('#permision-popup').remove();
        });
        return false;
      })
    });
  </script>
  <?php
  echo ob_get_clean();
}

add_action( 'wp_ajax_bwg_sr_data_collecting', 'bwg_sr_data_collecting_callback' );
function bwg_sr_data_collecting_callback() {
  add_option( 'bwg_sr_asked_permission', 1 );
  if ( WDWLibrary::get('accepted') == 1 ) {
    set_transient('bwg_sr_provided_permission', '1', MONTH_IN_SECONDS);
  }
  die(); // Otherwise automatically adds 0 to the end
}

if ( '1' === get_transient( 'bwg_sr_provided_permission' ) ) {
  add_action( 'admin_enqueue_scripts', 'bwg_sr_register_admin_scripts' );
  add_action( 'bwg_admin_scripts_after', 'bwg_sr_enqueue_scripts' );
  add_action( 'bwg_filemanager_scripts_after', 'bwg_sr_print_scripts' );
  add_action( 'bwg_shortcode_scripts_after', 'bwg_sr_print_scripts' );
}

add_action('bwg_print_options_general_after','bwg_print_sr_revoke');

function bwg_sr_register_admin_scripts() {
  wp_register_script(BWG()->prefix . '_screen_recorder', BWG()->plugin_url . '/framework/screen_recorder/bwg_screen_recorder.js', false, BWG()->plugin_version );
  wp_localize_script(BWG()->prefix . '_shortcode', 'bwg_objectscreen_recorder',
    array(
      'script_url' => BWG()->plugin_url . '/framework/screen_recorder/bwg_screen_recorder.js'));
}
function bwg_sr_enqueue_scripts() {
  wp_enqueue_script(BWG()->prefix . '_screen_recorder');
  wp_localize_script(BWG()->prefix . '_screen_recorder', 'screen_recorder_obj', array('home_url' => home_url()));
}
function bwg_sr_print_scripts() {
  ob_start();
  ?>
  <script>
    let screen_recorder_obj = {};
    screen_recorder_obj.home_url = '<?php echo home_url(); ?>'
  </script>
  <script src="<?php echo BWG()->plugin_url; ?>/framework/screen_recorder/bwg_screen_recorder.js?ver=<?php echo BWG()->plugin_version; ?>"></script>
  <?php
  echo ob_get_clean();
}

function bwg_print_sr_revoke() {
  ob_start();
?>
  <div class="wd-box-content wd-width-100">
    <div class="wd-group" id="revoke-data-collecting">
      <label class="wd-label"><?php _e('Photo Gallery Data Sharing', BWG()->prefix); ?></label>
      <input type="submit" class="button<?php echo get_transient('bwg_sr_provided_permission') ? '': '-primary'; ?> wd-data-sharing-button" id="revoke-btn" value="<?php get_transient('bwg_sr_provided_permission') ? _e('Disable access', BWG()->prefix) : _e('Enable access', BWG()->prefix); ?>" />
      <p class="description"><?php _e('Allow 10Web to collect data for the improvement of the Photo Gallery plugin. Your data will not be shared with 3rd parties and will be deleted after 30 days.', BWG()->prefix); ?></p>
    </div>
    <script>
      jQuery('#revoke-btn').click(function(e) {
        e.preventDefault();
      });
      var bwg_revoke_ajaxurl = "<?php echo add_query_arg(array('action' => 'bwg_revoke_data_collecting'), admin_url('admin-ajax.php')); ?>";
      var bwg_sr_enable_disable = "<?php echo get_transient('bwg_sr_provided_permission') ?>";

      jQuery(function($) {
        jQuery('#revoke-btn').click(function() {
          let data = {};
          if(bwg_sr_enable_disable == 1) {
            data = {
              'revoke': 1
            };
          } else {
            data = {
              'revoke': 0
            };
          }
          jQuery.post( bwg_revoke_ajaxurl, data, function() {
            jQuery('#loading_div', window.parent.document).show();
          }).done(function() {
            jQuery('#loading_div', window.parent.document).hide();
            if(data.revoke == 1) {
              jQuery('#revoke-btn').val("Enable access").removeClass('button').addClass('button-primary');
              bwg_sr_enable_disable = 0; // change value here because get_transient use caching
            } else if(data.revoke == 0) {
              jQuery('#revoke-btn').val("Disable access").removeClass('button-primary').addClass('button');
              bwg_sr_enable_disable = 1; // change value here because get_transient use caching
            }
          });
          return false;
        });
      });
    </script>
  </div>
<?php
  echo ob_get_clean();
}

add_action( 'wp_ajax_bwg_revoke_data_collecting', 'bwg_revoke_data_collecting_callback' );
function bwg_revoke_data_collecting_callback() {
  if ( WDWLibrary::get('revoke') == 1 ) {
    delete_transient('bwg_sr_provided_permission');
  } else if(WDWLibrary::get('revoke') == 0 ) {
    set_transient('bwg_sr_provided_permission', '1', MONTH_IN_SECONDS);
  }
  die(); // Otherwise automatically adds 0 to the end
}