<?php
class BWGViewCarousel extends BWGViewSite {

  public function display($params = array(), $bwg = 0) {
    $theme_row = $params['theme_row'];
    $image_rows = $params['image_rows'];
    $image_rows = $image_rows['images'];
    $images_count = count($image_rows);
    $inline_style = $this->inline_styles($bwg, $theme_row, $params);
    $lazyload = BWG()->options->lazyload_images;
    if ( !WDWLibrary::elementor_is_active() ) {
      if ( !$params['ajax'] ) {
        if ( BWG()->options->use_inline_stiles_and_scripts ) {
          wp_add_inline_style('bwg_frontend', $inline_style);
        }
        else {
          echo '<style id="bwg-style-' . $bwg . '">' . $inline_style . '</style>';
        }
      }
         else {
        echo '<style id="bwg-style-' . $bwg . '">' . $inline_style . '</style>';
      }
    }
    else {
      echo '<style id="bwg-style-' . $bwg . '">' . $inline_style . '</style>';
    }
    ob_start();
    if ( $images_count ) {
      $current_image_id = ($image_rows ? $image_rows[0]->id : 0);
      $image_width = $params['carousel_width'];
      $image_height = $params['carousel_height'];
      $enable_image_title = $params['enable_carousel_title'];
      $carousel_play_pause_butt = $params['carousel_play_pause_butt'];
      $carousel_enable_autoplay = $params['enable_carousel_autoplay'];
      $watermark_type = $params['watermark_type'];
      $watermark_text = $params['watermark_text'];
      $watermark_font_size = $params['watermark_font_size'];
      $watermark_link = $params['watermark_link'];
      $watermark_url = $params['watermark_url'];
      $watermark_width = $params['watermark_width'];
      $watermark_height = $params['watermark_height'];
      $data = array();
      foreach ( $image_rows as $key => $image_row ) {
        $data[$bwg][$key] = array();
        $data[$bwg][$key]["id"] = $image_row->id;
        $data[$bwg][$key]["alt"] = htmlspecialchars(esc_html($image_row->alt), ENT_COMPAT | ENT_QUOTES);
        $data[$bwg][$key]["description"] = htmlspecialchars(str_replace(array("\r\n", "\n", "\r"), esc_html('<br />'), esc_html($image_row->description)), ENT_COMPAT | ENT_QUOTES);
        $data[$bwg][$key]["image_url"] = htmlspecialchars($image_row->image_url, ENT_COMPAT | ENT_QUOTES);
        $data[$bwg][$key]["thumb_url"] = htmlspecialchars($image_row->thumb_url, ENT_COMPAT | ENT_QUOTES);
        $data[$bwg][$key]["date"] = $image_row->date;
        $data[$bwg][$key]["is_embed"] = (preg_match('/EMBED/', $image_row->filetype) == 1 ? true : false);
        $data[$bwg][$key]["is_embed_video"] = (((preg_match('/EMBED/', $image_row->filetype) == 1) && (preg_match('/_VIDEO/', $image_row->filetype) == 1)) ? true : false);
        $data[$bwg][$key]["is_embed_instagram_post"] = preg_match('/INSTAGRAM_POST/', $image_row->filetype) == 1 ? true : false;
        $bwg_param['data'] = $data[$bwg];
      }
      $bwg_param = array(
        'data' => $data[$bwg],
        'image_width' => $image_width,
        'image_height' => $image_height,
        'enable_image_title' => $enable_image_title,
        'carousel_interval' => $params['carousel_interval'],
        'carousel_image_column_number' => $params['carousel_image_column_number'] > $images_count ? $images_count : $params['carousel_image_column_number'],
        'carousel_enable_autoplay' => $carousel_enable_autoplay,
        'carousel_image_par' => $params['carousel_image_par'] > 1 ? 1 : $params['carousel_image_par'],
        'carousel_r_width' => $params['carousel_r_width'],
        'carousel_fit_containerWidth' => $params['carousel_fit_containerWidth'],
        'carousel_prev_next_butt' => $params['carousel_prev_next_butt'],
        'carousel_play_pause_butt' => $carousel_play_pause_butt,
        'car_inter' => $carousel_enable_autoplay ? $params['carousel_interval'] : 0,
        'watermark_type' => $watermark_type,
        'watermark_text' => $watermark_text,
        'watermark_font_size' => $watermark_font_size,
        'watermark_link' => $watermark_link,
        'watermark_url' => $watermark_url,
        'watermark_width' => $watermark_width,
        'watermark_height' => $watermark_height,
        'current_image_id' => $current_image_id,
        'carousel_play_pause_btn_size' => $theme_row->carousel_play_pause_btn_size,
        'bwg_currentCenterNum' => 1,
        'bwg_currentlyMoving' => false,
        'carousel' => '',
      );
      $bwg_params = json_encode($bwg_param);
      if ( BWG()->options->preload_images ) {
        if ( BWG()->options->preload_images_count == 0 ) {
          $carousel_image_column_number = count($image_rows);
        } else {
          $carousel_image_column_number = $bwg_param['carousel_image_column_number'] + BWG()->options->preload_images_count * 2;
        }
      } else {
        $carousel_image_column_number = $bwg_param['carousel_image_column_number'];
      }
      ?>
      <div class="bwg-carousel bwg_carousel-container<?php echo $bwg; ?> bwg-container"
           data-bwg="<?php echo $bwg; ?>" data-params='<?php echo $bwg_params; ?>'
           data-lightbox-url="<?php echo addslashes(add_query_arg($params['params_array'], admin_url('admin-ajax.php'))); ?>">
        <div id="bwg_carousel<?php echo $bwg; ?>" class="bwg_carousel-cont-child">
          <?php
          foreach ( $image_rows as $key => $image_row ) {
            $is_embed = preg_match('/EMBED/', $image_row->filetype) == 1 ? TRUE : FALSE;
            $is_embed_video = ($is_embed && preg_match('/_VIDEO/', $image_row->filetype) == 1) ? TRUE : FALSE;
            $is_embed_instagram_post = preg_match('/INSTAGRAM_POST/', $image_row->filetype) == 1 ? TRUE : FALSE;
            $current_image_alt = FALSE;
            if ( $image_row->id == $current_image_id ) {
              $current_image_alt = $image_row->alt;
            }
            $play_pause_button_display = '';
            if ( !$carousel_play_pause_butt || $is_embed_instagram_post ) {
              $play_pause_button_display = 'none';
            }
            ?>
            <div class="bwg_carousel-feature<?php echo $bwg; ?>" onclick="bwg_params_carousel[<?php echo $bwg; ?>]['carousel'].shift(this);" image_id="<?php echo $image_row->id; ?>" image_key="<?php echo $key; ?>">
              <div class="bwg_carousel_image_container_<?php echo $bwg; ?>">
              <span id="bwg_carousel_play_pause_<?php echo $bwg; ?>" class="bwg_carousel_play_pause" style="display: <?php echo $play_pause_button_display; ?>;">
                <span>
                  <span id="bwg_carousel_play_pause-ico_<?php echo $bwg; ?>" class="bwg_carousel_play_pause-ico">
                    <i class="bwg-icon-<?php echo $carousel_enable_autoplay ? 'pause' : 'play'; ?> bwg_ctrl_btn_<?php echo $bwg; ?> bwg_carousel_play_pause_<?php echo $bwg; ?>"></i>
                  </span>
                </span>
              </span>
                <?php
                if ( $watermark_type != 'none' ) {
                  ?>
                  <div class="bwg_carousel_watermark_container_<?php echo $bwg; ?>">
                    <div>
						<span class="bwg_carousel_watermark_spun_<?php echo $bwg; ?>" id="bwg_carousel_watermark_container_<?php echo $bwg; ?>">
						<?php
            if ( $watermark_type == 'image' ) {
              ?>
              <a class="bwg-a" href="<?php echo urldecode($watermark_link); ?>" target="_blank">
						  <img class="skip-lazy bwg_carousel_watermark_image_<?php echo $bwg; ?> bwg_carousel_watermark_<?php echo $bwg; ?> <?php if( $lazyload ) { ?> bwg_lazyload <?php } ?>"
                   data-original="<?php echo $watermark_url; ?>"
                   src="<?php if( !$lazyload ) { echo $watermark_url; } else { echo BWG()->plugin_url."/images/lazy_placeholder.gif"; } ?>" />
						</a>
              <?php
            }
            elseif ( $watermark_type == 'text' ) {
              ?>
              <a class="bwg_none_selectable_<?php echo $bwg; ?> bwg_carousel_watermark_text_<?php echo $bwg; ?> bwg_carousel_watermark_<?php echo $bwg; ?>" target="_blank" href="<?php echo urldecode($watermark_link); ?>"><?php echo $watermark_text; ?></a>
              <?php
            }
            ?>
						</span>
                    </div>
                  </div>
                  <?php
                }
                ?>
              </div>
              <?php
              if ( !$is_embed ) {
                $is_visible = $this->get_visiable_images($carousel_image_column_number, count($image_rows), $key);
                ?>
                <a id="bwg_img_link_<?php echo $key; ?>_<?php echo $bwg; ?>" <?php echo($params['thumb_click_action'] == 'open_lightbox' ? (' class="bwg_lightbox bwg_lightbox_' . $bwg . '"' . (BWG()->options->enable_seo ? ' href="' . ($is_embed ? $image_row->thumb_url : BWG()->upload_url . $image_row->image_url) . '"' : '') . ' data-image-id="' . $image_row->id . '" data-elementor-open-lightbox="no"') : ($params['thumb_click_action'] == 'redirect_to_url' && $image_row->redirect_url ? 'href="' . $image_row->redirect_url . '" target="' . ($params['thumb_link_target'] ? '_blank' : '') . '"' : '')) ?>>
                  <div <?php if ( $is_visible ) { ?> style="<?php echo "background-image: url('" . addslashes(htmlspecialchars_decode(BWG()->upload_url . $image_row->image_url, ENT_QUOTES)) . "');"; ?>" <?php } else { ?> id="bwg_carousel_preload_<?php echo $bwg; ?>_<?php echo $key; ?>" data-background = '<?php echo addslashes(htmlspecialchars_decode(BWG()->upload_url . $image_row->image_url, ENT_QUOTES)); ?>'<?php } ?>
                    class="bwg-carousel-image bwg_carousel-image<?php echo $bwg; ?> <?php if ( !$is_visible ) { ?> bwg_carousel_preload<?php } ?>"
                    alt="<?php echo $image_row->alt; ?>"></div>
                </a>
                <?php
              }
              else {
                ?>
                <span class="bwg_video_hide<?php echo $bwg; ?>"></span>
                <span class="<?php echo ($is_embed_video || $is_embed_instagram_post) ? "bwg_carousel_embed_video_" . $bwg : "bwg_carousel_embed_" . $bwg; ?>">
                <?php
                if ( $is_embed_instagram_post ) {
                  $post_width = $image_width;
                  $post_height = $image_height;
                  if ( $post_height < $post_width + 88 ) {
                    $post_width = $post_height - 88;
                  }
                  else {
                    $post_height = $post_width + 88;
                  }
                  $instagram_post_width = $post_width;
                  $instagram_post_height = $post_height;
                  $image_resolution = explode(' x ', $image_row->resolution);
                  if ( is_array($image_resolution) ) {
                    $instagram_post_width = $image_resolution[0];
                    $instagram_post_height = explode(' ', $image_resolution[1]);
                    $instagram_post_height = $instagram_post_height[0];
                  }
                  $is_visible = $this->get_visiable_images($carousel_image_column_number, count($image_rows), $key);
                  WDWLibraryEmbed::display_embed($image_row->filetype, $image_row->image_url, $image_row->filename, array(
                    'class' => "bwg_embed_frame_" . $bwg,
                    'data-width' => $instagram_post_width,
                    'data-height' => $instagram_post_height,
                    'frameborder' => "0",
                    'style' => "width:" . $post_width . "px; height:" . $post_height . "px; vertical-align:middle; display:table; position:relative;margin: 0 auto",
                    'is_visible' => $is_visible,
                    'image_key' => $key,
                    'bwg' => $bwg
                  ));
                }
                else {
                  $is_visible = $this->get_visiable_images($carousel_image_column_number, count($image_rows), $key);
                  WDWLibraryEmbed::display_embed($image_row->filetype, $image_row->image_url, $image_row->filename, array(
                    'class' => "bwg_embed_frame_" . $bwg,
                    'frameborder' => "0",
                    'allowfullscreen' => "allowfullscreen",
                    'style' => "width:100%; height:100%; vertical-align:middle;margin:0 auto;padding:0; display:table-cell;",
                    'is_visible' => $is_visible,
                    'image_key' => $key,
                    'bwg' => $bwg
                  ));
                }
                ?>
              </span>
                <?php
              }
              if ( $enable_image_title ) {
                ?>
                <div class="bwg_carousel-caption<?php echo $bwg; ?>">
                  <div class="bwg_carousel_title_text_<?php echo $bwg; echo ( !$current_image_alt ) ? ' hidden' : ''; ?>">
                    <?php echo html_entity_decode($image_row->alt); ?>
                  </div>
                </div>
                <?php
              }
              ?>
            </div>
            <?php
          }
          ?>
        </div>
        <div id="bwg_carousel-left<?php echo $bwg; ?>">
          <span id="spider_carousel_left-ico_<?php echo $bwg; ?>"><span><i class="<?php echo $theme_row->carousel_rl_btn_style; ?>-left bwg_carousel_prev_btn_<?php echo $bwg; ?>"></i></span></span>
        </div>
        <div id="bwg_carousel-right<?php echo $bwg; ?>">
          <span id="spider_carousel_right-ico_<?php echo $bwg; ?>"><span><i class="<?php echo $theme_row->carousel_rl_btn_style; ?>-right bwg_carousel_next_btn_<?php echo $bwg; ?>"></i></span></span>
        </div>
      </div>
      <?php
      $content = ob_get_clean();
      /* Set theme parameters for Gallery/Gallery group title/description.*/
      $theme_row->thumb_gal_title_font_size = $theme_row->carousel_gal_title_font_size;
      $theme_row->thumb_gal_title_font_color = $theme_row->carousel_gal_title_font_color;
      $theme_row->thumb_gal_title_font_style = $theme_row->carousel_gal_title_font_style;
      $theme_row->thumb_gal_title_font_weight = $theme_row->carousel_gal_title_font_weight;
      $theme_row->thumb_gal_title_shadow = $theme_row->carousel_gal_title_shadow;
      $theme_row->thumb_gal_title_margin = $theme_row->carousel_gal_title_margin;
      $theme_row->thumb_gal_title_align = $theme_row->carousel_gal_title_align;
      if ( $params['ajax'] ) { /* Ajax response after ajax call for filters and pagination.*/
        parent::ajax_content($params, $bwg, $content);
      }
      else {
        parent::container($params, $bwg, $content);
      }
    }
  }

  /**
   * Get first visible images in carousel.
   *
   * @param int $carousel_image_column_number
   * @param int $images_count
   * @param int $key
   *
   * @return bool
   */
  private function get_visiable_images( $carousel_image_column_number, $images_count, $key ) {

    if( $carousel_image_column_number > $images_count ) {
      $carousel_image_column_number = $images_count;
    }
    $right_count = floor($carousel_image_column_number/2);
    $left_count = $carousel_image_column_number - $right_count;
    if ( $key <= $right_count || $key > ($images_count-$left_count)){
      return true;
    }
    return false;
  }


  public function inline_styles($bwg, $theme_row, $params) {
    ob_start();
    $watermark_position = explode('-', $params['watermark_position']);
    $watermark_height = $params['watermark_height'];
    $watermark_width = $params['watermark_width'];
    $watermark_opacity = $params['watermark_opacity'];
    $watermark_font_size = $params['watermark_font_size'];
    $watermark_font = $params['watermark_font'];
    $watermark_color = $params['watermark_color'];
    $image_height = $params['carousel_height'];
    $image_width = $params['carousel_width'];

    $rgb_carousel_cont_bg_color = WDWLibrary::spider_hex2rgb($theme_row->carousel_cont_bg_color);
    ?>

    #bwg_container1_<?php echo $bwg; ?> #bwg_container2_<?php echo $bwg; ?> .bwg_carousel_watermark_spun_<?php echo $bwg; ?> {
        text-align: <?php echo $watermark_position[1]; ?>;
        vertical-align: <?php echo $watermark_position[0]; ?>;
    }
   
    #bwg_container1_<?php echo $bwg; ?> #bwg_container2_<?php echo $bwg; ?> .bwg_carousel_watermark_image_<?php echo $bwg; ?> {
        max-height: <?php echo $watermark_height; ?>px;
        max-width: <?php echo $watermark_width/2; ?>px;
        opacity: <?php echo number_format($watermark_opacity / 100, 2, ".", ""); ?>;
    }

    #bwg_container1_<?php echo $bwg; ?> #bwg_container2_<?php echo $bwg; ?> .bwg_carousel_watermark_text_<?php echo $bwg; ?>,
    #bwg_container1_<?php echo $bwg; ?> #bwg_container2_<?php echo $bwg; ?> .bwg_carousel_watermark_text_<?php echo $bwg; ?>:hover {
        font-size: <?php echo $watermark_font_size; ?>px;
        font-family: <?php echo $watermark_font; ?>;
        color: #<?php echo $watermark_color; ?> !important;
        opacity: <?php echo number_format($watermark_opacity / 100, 2, ".", ""); ?>;
    }

    #bwg_container1_<?php echo $bwg; ?> #bwg_container2_<?php echo $bwg; ?> #bwg_carousel<?php echo $bwg; ?> {
        margin-bottom: <?php echo $theme_row->carousel_mergin_bottom; ?>px;
        margin-top: <?php echo $theme_row->carousel_mergin_bottom; ?>px;
        font-size: <?php echo $theme_row->carousel_caption_p_font_size; ?>px;
        font-family: <?php echo $theme_row->carousel_font_family; ?>;
    }

    #bwg_container1_<?php echo $bwg; ?> #bwg_container2_<?php echo $bwg; ?> .bwg_carousel-container<?php echo $bwg; ?> {
        height: <?php echo $image_height; ?>px;
        background-color: rgba(<?php echo $rgb_carousel_cont_bg_color['red']; ?>, <?php echo $rgb_carousel_cont_bg_color['green']; ?>, <?php echo $rgb_carousel_cont_bg_color['blue']; ?>, <?php echo number_format($theme_row->carousel_cont_btn_transparent / 100, 2, ".", ""); ?>);
    }

    #bwg_container1_<?php echo $bwg; ?> #bwg_container2_<?php echo $bwg; ?> .bwg_carousel-feature<?php echo $bwg; ?> {
        border-width: <?php echo $theme_row->carousel_feature_border_width; ?>px;
        border-style: <?php echo $theme_row->carousel_feature_border_style; ?>;
        border-color: #<?php echo $theme_row->carousel_feature_border_color; ?>;
    }

    #bwg_container1_<?php echo $bwg; ?> #bwg_container2_<?php echo $bwg; ?> .bwg_carousel-feature<?php echo $bwg; ?> .bwg_carousel-caption<?php echo $bwg; ?> .bwg_carousel_title_text_<?php echo $bwg; ?> {
        background-color:#<?php echo $theme_row->carousel_caption_background_color; ?>;
        margin: <?php echo $theme_row->carousel_caption_p_mergin; ?>px;
        padding: <?php echo $theme_row->carousel_caption_p_pedding; ?>px;
        font-weight:<?php echo $theme_row->carousel_caption_p_font_weight; ?>;
        font-size:<?php echo $theme_row->carousel_caption_p_font_size; ?>px;
        opacity: <?php echo number_format($theme_row->carousel_title_opacity / 100, 2, ".", ""); ?>;
        border-radius: <?php echo $theme_row->carousel_title_border_radius; ?>;
        color:#<?php echo $theme_row->carousel_caption_p_color; ?>!important;
    }

    #bwg_container1_<?php echo $bwg; ?> #bwg_container2_<?php echo $bwg; ?> #bwg_carousel-right<?php echo $bwg; ?> {
        right: <?php echo 20 +  2 * $theme_row->carousel_rl_btn_border_width + $theme_row->carousel_rl_btn_width; ?>px;
    }

    #bwg_container1_<?php echo $bwg; ?> #bwg_container2_<?php echo $bwg; ?> #spider_carousel_left-ico_<?php echo $bwg; ?>,
    #bwg_container1_<?php echo $bwg; ?> #bwg_container2_<?php echo $bwg; ?> #spider_carousel_right-ico_<?php echo $bwg; ?> {
        background-color: #<?php echo $theme_row->carousel_rl_btn_bg_color; ?>;
        border-radius: <?php echo $theme_row->carousel_rl_btn_border_radius; ?>;
        border: <?php echo $theme_row->carousel_rl_btn_border_width; ?>px <?php echo $theme_row->carousel_rl_btn_border_style; ?> #<?php echo $theme_row->carousel_rl_btn_border_color; ?>;
        color: #<?php echo $theme_row->carousel_rl_btn_color; ?>;
        height: <?php echo $theme_row->carousel_rl_btn_height; ?>px;
        font-size: <?php echo $theme_row->carousel_rl_btn_size; ?>px;
        width: <?php echo $theme_row->carousel_rl_btn_width; ?>px;
        opacity: <?php echo number_format($theme_row->carousel_close_btn_transparent / 100, 2, ".", ""); ?>;
    }

    #bwg_container1_<?php echo $bwg; ?> #bwg_container2_<?php echo $bwg; ?> #spider_carousel_left-ico_<?php echo $bwg; ?>:hover,
    #bwg_container1_<?php echo $bwg; ?> #bwg_container2_<?php echo $bwg; ?> #spider_carousel_right-ico_<?php echo $bwg; ?>:hover {
        color: #<?php echo $theme_row->carousel_close_rl_btn_hover_color; ?>;
    }

    #bwg_container1_<?php echo $bwg; ?> #bwg_container2_<?php echo $bwg; ?> #bwg_carousel_play_pause_<?php echo $bwg; ?> {
        background: transparent url("<?php echo BWG()->plugin_url . '/images/blank.gif'; ?>") repeat scroll 0 0;
    }

    #bwg_container1_<?php echo $bwg; ?> #bwg_container2_<?php echo $bwg; ?> #bwg_carousel_play_pause_<?php echo $bwg; ?>:hover #bwg_carousel_play_pause-ico_<?php echo $bwg; ?> {
        display: inline-block !important;
    }

    #bwg_container1_<?php echo $bwg; ?> #bwg_container2_<?php echo $bwg; ?> #bwg_carousel_play_pause-ico_<?php echo $bwg; ?> {
        color: #<?php echo $theme_row->carousel_rl_btn_color; ?>;
        font-size: <?php echo $theme_row->carousel_play_pause_btn_size; ?>px;
    }

    #bwg_container1_<?php echo $bwg; ?> #bwg_container2_<?php echo $bwg; ?> #bwg_carousel_play_pause-ico_<?php echo $bwg; ?>:hover {  
        color: #<?php echo $theme_row->carousel_close_rl_btn_hover_color; ?>;
    }

    #bwg_container1_<?php echo $bwg; ?> #bwg_container2_<?php echo $bwg; ?> .bwg_carousel_embed_<?php echo $bwg; ?> {
        <?php
        if( $image_width > $image_height) {
        ?>
        margin-top: <?php echo ($image_height -$image_width) /2; ?>px;
        <?php
        }
        else {
        ?>
        margin-left: <?php echo ($image_width -$image_height) /2; ?>px;
        <?php
        }
        ?>
    }
    #bwg_container1_<?php echo $bwg; ?> #bwg_container2_<?php echo $bwg; ?> .bwg_gal_title_<?php echo $bwg; ?> {
    background-color: rgba(0, 0, 0, 0);
    color: #<?php echo $theme_row->carousel_gal_title_font_color; ?>;
    display: block;
    font-family: <?php echo $theme_row->carousel_gal_title_font_style; ?>;
    font-size: <?php echo $theme_row->carousel_gal_title_font_size; ?>px;
    font-weight: <?php echo $theme_row->carousel_gal_title_font_weight; ?>;
    padding: <?php echo $theme_row->carousel_gal_title_margin; ?>;
    text-shadow: <?php echo $theme_row->carousel_gal_title_shadow; ?>;
    text-align: <?php echo $theme_row->carousel_gal_title_align; ?>;
    }
    <?php
    return ob_get_clean();
  }
}
