<?php

class StockholmCoreElementorCustomFont extends \Elementor\Widget_Base{
	public function get_name() {
		return 'custom_font';
	}
	
	public function get_title() {
		return esc_html__( "Custom Font", 'stockholm-core' );
	}
	
	public function get_icon() {
		return 'stockholm-elementor-custom-icon stockholm-elementor-custom-font';
	}
	
	public function get_categories() {
		return [ 'select' ];
	}
	
	protected function _register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'stockholm-core' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
			'font_family',
			[
				'label' => esc_html__( "Font family", 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::TEXT
			]
		);
		
		$this->add_control(
			'font_size',
			[
				'label' => esc_html__( "Font size", 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '15'
			]
		);
		
		$this->add_control(
			'line_height',
			[
				'label' => esc_html__( "Line height", 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '26'
			]
		);
		
		$this->add_control(
			'font_style',
			[
				'label' => esc_html__( "Font Style", 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => stockholm_qode_get_font_style_array( true ),
				'default' => 'normal'
			]
		);
		
		$this->add_control(
			'text_align',
			[
				'label' => esc_html__( "Text Align", 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'left' => esc_html__( 'Left', 'stockholm-core' ),
					'center' => esc_html__( 'Center', 'stockholm-core' ),
					'right' => esc_html__( 'Right', 'stockholm-core' )
				],
				'default' => 'left'
			]
		);
		
		$this->add_control(
			'font_weight',
			[
				'label' => esc_html__( "Font weight", 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => stockholm_qode_get_font_weight_array(false),
				'default' => '300'
			]
		);
		
		$this->add_control(
			'color',
			[
				'label' => esc_html__( "Color", 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::COLOR
			]
		);
		
		$this->add_control(
			'text_decoration',
			[
				'label' => esc_html__( "Text Decoration", 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => stockholm_qode_get_text_decorations(false),
				'default' => 'none'
			]
		);
		
		$this->add_control(
			'text_shadow',
			[
				'label' => esc_html__( "Text Shadow", 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => stockholm_qode_get_yes_no_select_array(false, false),
				'default' => 'no'
			]
		);
		
		$this->add_control(
			'letter_spacing',
			[
				'label' => esc_html__( "Letter Spacing (px)", 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::TEXT
			]
		);
		
		$this->add_control(
			'background_color',
			[
				'label' => esc_html__( "Background Color", 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::COLOR
			]
		);
		
		$this->add_control(
			'padding',
			[
				'label' => esc_html__( "Padding (px)", 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '0'
			]
		);
		
		$this->add_control(
			'margin',
			[
				'label' => esc_html__( "Margin (px)", 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '0'
			]
		);
		
		$this->add_control(
			'content',
			[
				'label' => esc_html__( "Content", 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::WYSIWYG,
				'default' => '<p>' . esc_html__( 'content content content', 'stockholm-core' ) . '</p>'
			]
		);
		
		$this->end_controls_section();

        // Add predefined developer tab content for each shortcode element
        $this->start_controls_section(
            'developer_tools',
            [
                'label' => esc_html__( 'Developer Tools', 'stockholm-core' ),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'shortcode_snippet',
            [
                'label'   => esc_html__( 'Show Shortcode Snippet', 'stockholm-core' ),
                'type'    => \Elementor\Controls_Manager::SELECT,
                'default' => 'no',
                'options' => stockholm_qode_get_yes_no_select_array()
            ]
        );

        $this->end_controls_section();
	}
	
	protected function render(){
		$params = $this->get_settings_for_display();

		if( ! empty( $params['shortcode_snippet'] ) && $params['shortcode_snippet'] == 'yes' ){
            echo $this->get_shortcode_snippet( $params );
        } else{
            echo stockholm_qode_get_shortcode_template_part('templates/custom-font', '_custom-font', '', $params);
        }
	}

    private function get_shortcode_snippet( $params )
    {
        $atts = array();

        if (empty($this) || !is_object($this)) {
            return '';
        }

        if (!empty($params)) {
            foreach ($params as $key => $value) {
                if (is_array($value) || $key === 'shortcode_snippet') {
                    continue;
                }

                if (empty($value) || $value == '') {
                    continue;
                }

                $atts[] = $key . '="' . esc_attr($value) . '"';
            }
        }

        return sprintf('<textarea class="qode-shortcode-snipper-holder" rows="3" readonly>[%s %s]%s[/%s]</textarea>',
            'custom_font',
            implode(' ', $atts),
            $params['content'],
            'custom_font'
        );
    }
	
}

\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new StockholmCoreElementorCustomFont() );