<?php

class StockholmCoreElementorProgressBar extends \Elementor\Widget_Base{
    public function get_name() {
        return 'progress_bar';
    }

    public function get_title() {
        return esc_html__( 'Progress Bar - Horizontal', 'stockholm-core' );
    }

    public function get_icon() {
        return 'stockholm-elementor-custom-icon stockholm-elementor-progress-bar';
    }

    public function get_categories() {
        return [ 'select' ];
    }

    protected function _register_controls() {

	   $this->start_controls_section(
            'general',
            [
                'label' => esc_html__( 'General', 'stockholm-core' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

		$this->add_control(
			'title',
			[
				'label' => esc_html__( 'Title', 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'title_color',
			[
				'label' => esc_html__( 'Title Color', 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::COLOR
			]
		);

		$this->add_control(
			'title_tag',
			[
				'label' => esc_html__( 'Title Tag', 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => stockholm_qode_get_title_tag( true ),
				'default' => 'h4'
			]
		);
	
	    $this->add_control(
		    'title_custom_size',
		    [
			    'label' => esc_html__( 'Title Custom Size (px)', 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::TEXT
		    ]
	    );

		$this->add_control(
			'percent',
			[
				'label' => esc_html__( 'Percentage', 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '100'
			]
		);
	
	    $this->add_control(
		    'show_percent_mark',
		    [
			    'label' => esc_html__( 'Show Percentage Mark', 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => [
				    "with_mark"    => esc_html__( "Yes", 'stockholm' ),
				    "without_mark" => esc_html__( "No", 'stockholm' )
			    ],
			    'default' => 'with_mark',
			    'condition' => [
				    'percent!' => ''
			    ]
		    ]
	    );

		$this->add_control(
			'percent_color',
			[
				'label' => esc_html__( 'Percentage Color', 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'percent!' => ''
				]
			]
		);

		$this->add_control(
			'percent_font_size',
			[
				'label' => esc_html__( 'Percentage Font Size', 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'condition' => [
					'percent!' => ''
				]
			]
		);

		$this->add_control(
			'percent_font_weight',
			[
				'label' => esc_html__( 'Percentage Font weight', 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => stockholm_qode_get_font_weight_array(true),
				'default' => '',
				'condition' => [
					'percent!' => ''
				]
			]
		);

		$this->add_control(
			'active_background_color',
			[
				'label' => esc_html__( 'Active Background Color', 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::COLOR
			]
		);

		$this->add_control(
			'active_border_color',
			[
				'label' => esc_html__( 'Active Border Color', 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::COLOR
			]
		);

		$this->add_control(
			'noactive_background_color',
			[
				'label' => esc_html__( 'Inactive Background Color', 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::COLOR
			]
		);
		
		$this->add_control(
			'height',
			[
				'label' => esc_html__( 'Progress Bar Height (px)', 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'border_radius',
			[
				'label' => esc_html__( 'Progress Bar Border Radius', 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::TEXT
			]
		);
		
        $this->end_controls_section();
    }

    protected function render(){
        $params = $this->get_settings_for_display();

        echo stockholm_qode_get_shortcode_template_part('templates/progress-bar', '_progress-bar', '', $params);
    }

}

\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new StockholmCoreElementorProgressBar() );