<?php

class StockholmCoreElementorServiceTable extends \Elementor\Widget_Base{
    public function get_name() {
        return 'service_table';
    }

    public function get_title() {
        return esc_html__( 'Service Table', 'stockholm-core' );
    }

    public function get_icon() {
        return 'stockholm-elementor-custom-icon stockholm-elementor-service-table';
    }

    public function get_categories() {
        return [ 'select' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'general',
            [
                'label' => esc_html__( 'General', 'stockholm-core' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => esc_html__( "Title", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::TEXT
            ]
        );

	    $this->add_control(
		    'title_tag',
		    [
			    'label' => esc_html__( "Title Tag", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => stockholm_qode_get_title_tag(false),
			    'default' => 'h4'
		    ]
	    );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__( "Title/Title Icon Color", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::COLOR,
            ]
        );

	    $this->add_control(
		    'title_background_type',
		    [
			    'label' => esc_html__( "Title Background Type", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => array(
				    "background_color_type"   => esc_html__( 'Background Color', 'stockholm-core' ),
				    "background_image_type"   => esc_html__( 'Background Image', 'stockholm-core' )
			    )
		    ]
	    );

	    $this->add_control(
		    'title_background_color',
		    [
			    'label' => esc_html__( "Title Background Color", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::COLOR,
			    'condition' => [
			        'title_background_type' => 'background_color_type'
		        ]
		    ]
	    );

	    $this->add_control(
		    'background_image',
		    [
			    'label' => esc_html__( 'Background Image', 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::MEDIA,
			    'condition' => [
				    'title_background_type' => 'background_image_type'
			    ]
		    ]
	    );

	    $this->add_control(
		    'background_image_height',
		    [
			    'label' => esc_html__( "Background Image Height (px)", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::TEXT,
			    'condition' => [
				    'title_background_type' => 'background_image_type'
			    ]
		    ]
	    );
	
	    stockholm_qode_icon_collections()->getElementorParamsArray($this, '', '', true);
	    
	    $this->add_control(
		    'custom_size',
		    [
			    'label' => esc_html__( "Custom Size (px)", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::TEXT
		    ]
	    );
	    
	    $this->add_control(
		    'content_background_color',
		    [
			    'label' => esc_html__( "Content Background Color", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::COLOR
		    ]
	    );

	    $this->add_control(
		    'border',
		    [
			    'label' => esc_html__( "Border Around", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => stockholm_qode_get_yes_no_select_array()
		    ]
	    );

	    $this->add_control(
		    'border_width',
		    [
			    'label' => esc_html__( "Border width (px)", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::TEXT,
			    'condition' => [
				    'border' => 'yes'
			    ]
		    ]
	    );

	    $this->add_control(
		    'border_color',
		    [
			    'label' => esc_html__( "Border color", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::COLOR,
			    'condition' => [
				    'border' => 'yes'
			    ]
		    ]
	    );

	    $this->add_control(
		    'content',
		    [
			    'label' => esc_html__( "Content", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::WYSIWYG,
			    'default' => '<li>' . esc_html__( 'content content content', 'stockholm-core' ) . '</li><li>' . esc_html__( 'content content content', 'stockholm-core' ) . '</li><li>' . esc_html__( 'content content content', 'stockholm-core' ) . '</li>'

		    ]
	    );

        $this->end_controls_section();
    }

    protected function render(){
        $params = $this->get_settings_for_display();
	
	    $params['icon'] = stockholm_qode_icon_collections()->getElementorIconFromIconPack( $params );

		if( ! empty( $params['background_image'] ) ){
			$params['background_image'] = $params['background_image']['id'];
		}

        echo stockholm_qode_get_shortcode_template_part('templates/service-table', '_service-table', '', $params);
    }

}

\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new StockholmCoreElementorServiceTable() );