(function($) {
    'use strict';
    
    var imageMarquee = {};
    qode.modules.imageMarquee = imageMarquee;
    
    imageMarquee.qodeInitImageMarquee = qodeInitImageMarquee;
    imageMarquee.qodeElementorInitImageMarquee = qodeElementorInitImageMarquee;

    imageMarquee.qodeOnDocumentReady = qodeOnDocumentReady;
    
    $(document).ready(qodeOnDocumentReady);
    $(window).on('load', qodeOnWindowLoad());
    
    /*
     All functions to be called on $(document).ready() should be in this function
     */
    function qodeOnDocumentReady() {
        qodeInitImageMarquee();
    }

    function qodeOnWindowLoad() {
        qodeElementorInitImageMarquee();
    }
    
    /**
     * Init Image Marquee effect
     */
    function qodeInitImageMarquee() {
        var imageMarqueeShortcodes = $('.qode-image-marquee');

        if (imageMarqueeShortcodes.length) {

            imageMarqueeShortcodes.each(function(){
                var imageMarqueeShortcode = $(this),
                    marqueeElements = imageMarqueeShortcode.find('.qode-image'),
                    originalItem = marqueeElements.filter('.qode-original'),
                    auxItem = marqueeElements.filter('.qode-aux');

                var marqueeEffect = function () {
	                
                    var delta = 1, //pixel movement
                        speedCoeff = 0.8, // below 1 to slow down, above 1 to speed up
                        marqueeWidth = originalItem.width();

                    auxItem.css('width', marqueeWidth); //same width as the initial marquee element
                    auxItem.css('left', marqueeWidth); //set to the right of the initial marquee element

                    //movement loop
                    marqueeElements.each(function(i){
                        var marqueeElement = $(this),
							currentPos = 0,
							animFrame;

                        var qodeInfiniteScrollEffect = function() {
                            currentPos -= delta;

                            //move marquee element
                            if (marqueeElement.position().left <= -marqueeWidth) {
                                marqueeElement.css('left', parseInt(marqueeWidth - delta));
                                currentPos = 0;
                            }

                            marqueeElement.css('transform','translate3d('+speedCoeff*currentPos+'px,0,0)');
	
	                        animFrame = requestAnimationFrame(qodeInfiniteScrollEffect);
                        }; 
						animFrame = requestAnimationFrame(qodeInfiniteScrollEffect);

						// Function to reset marquee on mobile orientation change
						function qodeOrientationChange() {
							marqueeWidth = originalItem.width();
							currentPos = 0;
							originalItem.css('left',0); // reset
							auxItem.css('width', marqueeWidth); //same width as the initial marquee element
							auxItem.css('left', marqueeWidth); //set to the right of the inital marquee element
						}
						  
						window.addEventListener('orientationchange', qodeOrientationChange);
						
						// Mobile Safari touch blocking fix
						qode_body.on('touchstart', function(e) {
							if(!$.contains(imageMarqueeShortcode.get(0), e.target)) {
								if (animFrame) {
									cancelAnimationFrame(animFrame);
									animFrame = null;
	
									setTimeout(function() {
										animFrame = requestAnimationFrame(qodeInfiniteScrollEffect);
									}, 300);
								}
							}
						});
                    });
                };

                imageMarqueeShortcode.waitForImages(function(){
	                marqueeEffect();
	            });
            });
        }
    }

    /**
     * Elementor
     */
    function qodeElementorInitImageMarquee(){
        $(window).on('elementor/frontend/init', function () {
            elementorFrontend.hooks.addAction( 'frontend/element_ready/qode_image_marquee.default', function() {
                qodeInitImageMarquee();
            } );
        });
    }
})(jQuery);