<?php
$_video_type = get_post_meta( get_the_ID(), "video_format_choose", true );

if ( $_video_type == "youtube" ) { ?>
	<iframe src="https://www.youtube.com/embed/<?php echo esc_attr( get_post_meta( get_the_ID(), "video_format_link", true ) ); ?>?wmode=transparent" wmode="Opaque" frameborder="0" width="1300" height="731" allowfullscreen></iframe>
<?php } elseif ( $_video_type == "vimeo" ) { ?>
	<iframe src="https://player.vimeo.com/video/<?php echo esc_attr( get_post_meta( get_the_ID(), "video_format_link", true ) ); ?>?title=0&amp;byline=0&amp;portrait=0" frameborder="0" width="1300" height="731" webkitAllowFullScreen mozallowfullscreen allowFullScreen></iframe>
<?php } elseif ( $_video_type == "self" ) { ?>
	<div class="video">
		<div class="mobile-video-image" style="background-image: url(<?php echo get_post_meta( get_the_ID(), "video_format_image", true ); ?>);"></div>
		<div class="video-wrap">
			<video class="video" poster="<?php echo esc_url( get_post_meta( get_the_ID(), "video_format_image", true ) ); ?>" preload="auto">
				<?php if ( get_post_meta( get_the_ID(), "video_format_webm", true ) != "" ) { ?>
					<source type="video/webm" src="<?php echo esc_url( get_post_meta( get_the_ID(), "video_format_webm", true ) ); ?>">
				<?php } ?>
				<?php if ( get_post_meta( get_the_ID(), "video_format_mp4", true ) != "" ) { ?>
					<source type="video/mp4" src="<?php echo esc_url( get_post_meta( get_the_ID(), "video_format_mp4", true ) ); ?>">
				<?php } ?>
				<?php if ( get_post_meta( get_the_ID(), "video_format_ogv", true ) != "" ) { ?>
					<source type="video/ogg" src="<?php echo esc_url( get_post_meta( get_the_ID(), "video_format_ogv", true ) ); ?>">
				<?php } ?>
				<object width="320" height="240" type="application/x-shockwave-flash" data="<?php echo get_template_directory_uri(); ?>/js/flashmediaelement.swf">
					<param name="movie" value="<?php echo get_template_directory_uri(); ?>/js/flashmediaelement.swf"/>
					<param name="flashvars" value="controls=true&file=<?php echo get_post_meta( get_the_ID(), "video_format_mp4", true ); ?>"/>
					<img src="<?php echo esc_url( get_post_meta( get_the_ID(), "video_format_image", true ) ); ?>" width="1920" height="800" title="<?php esc_attr_e( 'No video playback capabilities', 'stockholm' ); ?>" alt="<?php esc_attr_e( 'Video thumb', 'stockholm' ); ?>"/>
				</object>
			</video>
		</div>
	</div>
<?php } ?>