<?php

class StockholmQodeRestaurantElementorRestaurantMenu extends \Elementor\Widget_Base{
    public function get_name() {
        return 'qode_restaurant_menu_list';
    }

    public function get_title() {
        return esc_html__( 'Restaurant Menu List', 'select-restaurant' );
    }

    public function get_icon() {
        return 'stockholm-elementor-custom-icon stockholm-elementor-restaurant-menu';
    }

    public function get_categories() {
        return [ 'select-restaurant' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'general',
            [
                'label' => esc_html__( 'General', 'select-restaurant' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
	
	    $this->add_control(
		    'show_featured_image',
		    [
			    'label' => esc_html__('Show Featured Image?', 'select-restaurant'),
			    'description' => esc_html__('Use this option to show featured image of menu items', 'select-restaurant'),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => stockholm_qode_get_yes_no_select_array(true,true),
			    'default' => ''
		    ]
	    );
	
	    $this->add_control(
		    'title_tag',
		    [
			    'label' => esc_html__('Title Tag', 'select-restaurant'),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => stockholm_qode_get_title_tag( true, array( 'p' => 'p' ) ),
			    'default' => 'h3'
		    ]
	    );

	    $this->add_control(
		    'price_tag',
		    [
			    'label' => esc_html__('Price Tag', 'select-restaurant'),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => stockholm_qode_get_title_tag( true, array( 'p' => 'p' ) ),
			    'default' => 'h5'
		    ]
	    );

	    $this->add_control(
		    'description_tag',
		    [
			    'label' => esc_html__('Description Tag', 'select-restaurant'),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => stockholm_qode_get_title_tag( true, array( 'p' => 'p' ) ),
			    'default' => 'h6'
		    ]
	    );

	    $this->add_control(
		    'skin',
		    [
			    'label' => esc_html__('Skin', 'select-restaurant'),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => [
				    'dark'  => esc_html__('Dark', 'select-restaurant'),
				    'light' => esc_html__('Light', 'select-restaurant'),
			    ],
			    'default' => 'dark'
		    ]
	    );
	    
        $this->end_controls_section();

        $this->start_controls_section(
            'query',
            [
                'label' => esc_html__('Query and Layout Options', 'select-restaurant'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'order_by',
            [
                'label' => esc_html__('Order By', 'select-restaurant'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'menu_order' => esc_html__('Menu Order', 'select-restaurant'),
                    'title'      => esc_html__('Title', 'select-restaurant'),
                    'date'       => esc_html__('Date', 'select-restaurant'),
                ],
                'default' => 'date'
            ]
        );

        $this->add_control(
            'order',
            [
                'label' => esc_html__('Order', 'select-restaurant'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => stockholm_qode_get_query_order_array(),
                'default' => 'ASC'
            ]
        );

        $this->add_control(
            'restaurant_menu_category',
            [
                'label' => esc_html__('Restaurant Menu Category', 'select-restaurant'),
                'description' => esc_html__('Enter one cafe menu category slug (leave empty for showing all cafe menu categories)', 'select-restaurant'),
                'type' => \Elementor\Controls_Manager::TEXT
            ]
        );

        $this->add_control(
            'number',
            [
                'label' => esc_html__('Number of Restaurant Menu Items', 'select-restaurant'),
                'description' => esc_html__('(enter -1 to show all)', 'select-restaurant'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => '-1'
            ]
        );
        
        $this->end_controls_section();
    }

    protected function render(){
        $params = $this->get_settings_for_display();
	
	    $query_array = $this->getQueryArray($params);
	    $query_results = new \WP_Query($query_array);

	    $params['price_tag'] = ! empty($params['price_tag']) ? $params['price_tag'] : 'h5';
	    $params['description_tag'] = ! empty($params['description_tag']) ? $params['description_tag'] : 'h6';

	    $listItemParams = array(
		    'show_featured_image'	=> $params['show_featured_image'],
		    'title_tag'				=> $params['title_tag'],
		    'price_tag'				=> $params['price_tag'],
		    'description_tag'       => $params['description_tag'],
	    );
	
	    $holderClasses = $this->getHolderClasses($params);
	
	    $html = '<div '.stockholm_qode_get_class_attribute($holderClasses).'>';
	
	    if($query_results->have_posts()) {
		    $html .= '<ul class="qode-rml-holder">';
		
		    while($query_results->have_posts()) {
			    $query_results->the_post();
			    $html .= stockholm_qode_restaurant_get_shortcode_module_template_part('restaurant-menu', 'templates/restaurant-menu-list-item', '', $listItemParams);
		    }
		
		    $html .= '</ul>';
		
		    wp_reset_postdata();
	    } else {
		    $html .= '<p>'.esc_html__('Sorry, no menu items matched your criteria.', 'select-restaurant').'</p>';
	    }
	
	    $html .= '</div>';
	    
	    echo stockholm_qode_get_module_part($html);
    }
	
	/**
	 * Generates menu list query attribute array
	 *
	 * @param $params
	 *
	 * @return array
	 */
	public function getQueryArray($params){
		
		$query_array = array(
			'post_type' => 'qode-restaurant-menu',
			'orderby' =>$params['order_by'],
			'order' => $params['order'],
			'posts_per_page' => $params['number']
		);
		
		if(!empty($params['restaurant_menu_category'])){
			$query_array['qode-restaurant-menu-category'] = $params['restaurant_menu_category'];
		}
		
		return $query_array;
	}
	
	private function getHolderClasses($params) {
		$classes = array('qode-restaurant-menu-list');
		
		if($params['show_featured_image'] === 'yes') {
			$classes[] = 'qode-rml-with-featured-image';
		}
		
		if($params['skin'] === 'light') {
			$classes[] = 'qode-rml-light';
		}
		
		return $classes;
	}
}

\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new StockholmQodeRestaurantElementorRestaurantMenu() );