(function ($) {
	'use strict';

	var portfolioListHorizontal = {};
	qode.modules.portfolioListHorizontal = portfolioListHorizontal;

	portfolioListHorizontal.qodeOnDocumentReady = qodeOnDocumentReady;

	$(document).ready(qodeOnDocumentReady);
	$(window).on('load', qodeOnWindowLoad);

    /*
     All functions to be called on $(document).ready() should be in this function
     */
	function qodeOnDocumentReady() {
		qodeInitPortfolioListHorizontal();
	}

	/*
	 ** All functions to be called on $(window).load() should be in this function
	 */
	function qodeOnWindowLoad() {
		qodeInitElementorPortfolioListHorizontal();
	}

	function qodeInitPortfolioListHorizontal() {
		var list = $('.qode-portfolio-list-horizontal-holder');

		if (list.length && $window_width >= 768) {
			var listInner = list.find('.qode-plh-inner'),
				items = list.find('.qode-plh-item'),
				listWidth = 0,
				widthVal = 395;

			var widthCalcs = function () {
				//custom sizing
				if ($window_width <= 1440 && $window_width > 1280) {
					if ($window_height <= 645) {
						widthVal = 200;
					} else {
						widthVal = 260;
					}
				} else if ($window_width <= 1280 && $window_width > 1024) {
					widthVal = 220;
				} else if ($window_width <= 1024 && $window_width > 768) {
					widthVal = 250;
				} else if ($window_width == 768) {
					widthVal = 320;
				} else { widthVal = 395; }

				listWidth = 0;
				items.each(function () {
					var item = $(this),
						itemWidth = item.hasClass('qode-plh-featured') ? widthVal * 1.23 : widthVal;

					listWidth += itemWidth;
					item.width(itemWidth);
				});

				listInner.width(listWidth);
			}

			var heightCalcs = function () {
				var height = $window_height;

				listInner.css({ 'height': height });
			}

			heightCalcs();
			widthCalcs();
			
			if (qode_body.hasClass('eltdf-smooth-page-transitions-preloader')) {
				$(document).on('eltdfLoaderRemoved', function() {
					listInner.addClass('eltdf-ready');
				});
			} else {
				listInner.addClass('eltdf-ready');
			}

			$(window).resize(function () {
				heightCalcs();
				widthCalcs();
			});

			if (qode_htmlEl.hasClass('touch')) {
				//custom horizontal touch nav using hammer
				var section = document.querySelector('.qode-plh-inner'),
					$section = $('.qode-plh-inner'),
					sectionH = new Hammer(section),
					transformVal = 0;

				var moveContent = function (delta) {
					$section.css('transform', 'translate3d(' + delta + 'px, 0, 0)')
				}

				sectionH.on("swipe", function (ev) {
					if (ev.deltaX > 0) {
						transformVal += ev.distance;
						transformVal = Math.min(0, transformVal);
					} else {
						transformVal -= ev.distance;
						transformVal = -Math.min(listWidth - $section.parent().width() - parseInt($section.find('article:last-child').css('margin-right')), Math.abs(transformVal));
					}

					moveContent(transformVal);
				});

				$(window).on('resize', function () {
					//prevent overscroll
					if (Math.abs(transformVal) >= listWidth - $section.parent().width() - parseInt($section.find('article:last-child').css('margin-right'))) {
						moveContent(-listWidth + $section.parent().width() + parseInt($section.find('article:last-child').css('margin-right')));
					}
				});
			} else {
				//custom smooth horizontal scroll using virtual scroll
				var section = document.querySelector('.qode-plh-inner'),
					sectionWidth = section.getBoundingClientRect().width,
					targetX = 0,
					currentX = 0,
					ease = 0.08,
					coeff = parseInt(list.parent().css('paddingLeft')) * 2
						- parseInt(window.getComputedStyle(section.querySelector('article:last-child')).marginRight); //adj.

				qode_htmlEl
					.add(qode_body)
					.addClass('qode-overflow-hidden');

				//eltdf.modules.common.eltdfDisableScroll();

				window.addEventListener('resize', function () {
					coeff = parseInt(list.parent().css('paddingLeft')) * 2
						- parseInt(window.getComputedStyle(section.querySelector('article:last-child')).marginRight);
					sectionWidth = section.getBoundingClientRect().width;
				})

				VirtualScroll.on(function (e) {
					targetX += e.deltaY;
					targetX = Math.max((sectionWidth - window.innerWidth + coeff) * -1, targetX);
					targetX = Math.min(0, targetX);
				});

				var performScroll = function () {
					requestAnimationFrame(performScroll);
					currentX += (targetX - currentX) * ease;
					var t = 'translate3d(' + currentX + 'px, 0px, 0px)';
					var s = section.style;
					s["transform"] = t;
					s["webkitTransform"] = t;
					s["mozTransform"] = t;
					s["msTransform"] = t;
				}

				performScroll();
			}
		}
	}

	function qodeInitElementorPortfolioListHorizontal() {
		$(window).on('elementor/frontend/init', function () {
			elementorFrontend.hooks.addAction( 'frontend/element_ready/qode_portfolio_list_horizontal.default', function() {
				qodeInitPortfolioListHorizontal();
			} );
		});
	}

})(jQuery);
