<?php

class StockholmCorePortfolioListHorizontal extends \Elementor\Widget_Base{
	public function get_name() {
		return 'qode_portfolio_list_horizontal';
	}

	public function get_title() {
		return esc_html__( "Portfolio List Horizontal", 'stockholm-core' );
	}

	public function get_icon() {
		return 'stockholm-elementor-custom-icon stockholm-elementor-portfolio-list-horizontal';
	}

	public function get_categories() {
		return [ 'select' ];
	}

	private function getAllPortfolioItems(){
		$portfolios = get_posts([
			'post_type' => 'portfolio_page',
			'post_status' => 'publish',
			'numberposts' => -1
		]);

		$portfolios_formatted = array();

		if( is_array( $portfolios ) && count( $portfolios ) > 0 ){
			foreach ( $portfolios as $portfolio ){
				$portfolios_formatted[$portfolio->ID] = $portfolio->post_title;
			}
		}

		return $portfolios_formatted;
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'stockholm-core' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'number_of_items',
			[
				'label' => esc_html__( 'Number of Portfolios Per Page', 'stockholm-core' ),
				'description' => esc_html__( 'Set number of items for your portfolio list. Enter -1 to show all.', 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '-1'
			]
		);

		$this->add_control(
			'image_proportions',
			[
				'label' => esc_html__( 'Image Proportions', 'stockholm-core' ),
				'description' => esc_html__( 'Set image proportions for your portfolio list.', 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'full' => esc_html__( 'Original', 'stockholm-core' ),
					'square' => esc_html__( 'Square', 'stockholm-core' ),
					'landscape' => esc_html__( 'Landscape', 'stockholm-core' ),
					'portrait' => esc_html__( 'Portrait', 'stockholm-core' ),
					'medium' => esc_html__( 'Medium', 'stockholm-core' ),
					'large' => esc_html__( 'Large', 'stockholm-core' ),
				],
				'default' => 'full'
			]
		);

		$this->add_control(
			'featured_project',
			[
				'label' => esc_html__( 'Choose Featured Project', 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => $this->getAllPortfolioItems()
			]
		);

		$this->add_control(
			'category',
			[
				'label' => esc_html__( 'One-Category Portfolio List', 'stockholm-core' ),
				'description' => esc_html__( 'Enter one category slug (leave empty for showing all categories)', 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'selected_projects',
			[
				'label' => esc_html__( 'Show Only Projects with Listed IDs', 'stockholm-core' ),
				'description' => esc_html__( 'Delimit ID numbers by comma (leave empty for all)', 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'options' => $this->getAllPortfolioItems(),
				'multiple' => true
			]
		);

		$this->add_control(
			'tag',
			[
				'label' => esc_html__( 'One-Tag Portfolio List', 'stockholm-core' ),
				'description' => esc_html__( 'Enter one tag slug (leave empty for showing all tags)', 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'orderby',
			[
				'label' => esc_html__( 'Order By', 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => stockholm_qode_get_query_order_by_array(),
				'default' => 'date'
			]
		);

		$this->add_control(
			'order',
			[
				'label' => esc_html__( 'Order By', 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => stockholm_qode_get_query_order_array(),
				'default' => 'ASC'
			]
		);

		$this->end_controls_section();
	}

	protected function render(){
		$args   = array(
			'number_of_items'          => '-1',
			'image_proportions'        => 'full',
			'featured_project' 		   => '',
			'category'                 => '',
			'selected_projects'        => '',
			'tag'                      => '',
			'orderby'                  => 'date',
			'order'                    => 'ASC'
		);
		$params = $this->get_settings_for_display();

		$params = shortcode_atts( $args, $params );

		/***
		 * @params query_results
		 * @params holder_data
		 * @params holder_classes
		 * @params holder_inner_classes
		 */
		$additional_params = array();

		$query_array                        = $this->getQueryArray( $params );
		$query_results                      = new \WP_Query( $query_array );
		$params['query_results'] = $query_results;

		$params['holder_classes']    = $this->getHolderClasses( $params, $args );

		$params['this_object'] = $this;

		echo stockholm_qode_get_shortcode_template_part( 'templates/portfolio-holder', 'portfolio-list-horizontal', '', $params );
	}

	public function getQueryArray( $params ) {
		$query_array = array(
			'post_status'    => 'publish',
			'post_type'      => 'portfolio_page',
			'posts_per_page' => $params['number_of_items'],
			'orderby'        => $params['orderby'],
			'order'          => $params['order']
		);

		if ( ! empty( $params['category'] ) ) {
			$query_array['portfolio-category'] = $params['category'];
		}

		if( is_array( $params['selected_projects'] ) && count( $params['selected_projects'] ) > 0 ){
			$params['selected_projects'] = implode(',', $params['selected_projects']);
		}

		$project_ids = null;
		if ( ! empty( $params['selected_projects'] ) ) {
			$project_ids             = explode( ',', $params['selected_projects'] );
			$query_array['post__in'] = $project_ids;
		}

		//exclude featured project
		if ( ! empty( $params['featured_project'] ) ) {
			$query_array['post__not_in'] = array($params['featured_project']);
		}

		if ( ! empty( $params['tag'] ) ) {
			$query_array['portfolio-tag'] = $params['tag'];
		}

		if ( ! empty( $params['next_page'] ) ) {
			$query_array['paged'] = $params['next_page'];
		} else {
			$query_array['paged'] = 1;
		}

		return $query_array;
	}

	public function getHolderClasses( $params, $args ) {
		$classes = array();

		$classes[] = ! empty( $params['featured_project'] ) ? 'qode-hsp-has-featured' : '';

		return implode( ' ', $classes );
	}

	public function getArticleClasses( $params ) {
		$classes = array();

		$article_classes = get_post_class( $classes );

		return implode( ' ', $article_classes );
	}

	public function getImageSize( $params ) {
		$thumb_size = 'full';

		if ( ! empty( $params['image_proportions'] ) ) {
			$image_size = $params['image_proportions'];

			switch ( $image_size ) {
				case 'landscape':
					$thumb_size = 'portfolio_masonry_wide';
					break;
				case 'portrait':
					$thumb_size = 'portfolio_masonry_tall';
					break;
				case 'square':
					$thumb_size = 'portfolio_masonry_regular';
					break;
				case 'medium':
					$thumb_size = 'medium';
					break;
				case 'large':
					$thumb_size = 'large';
					break;
				case 'full':
					$thumb_size = 'full';
					break;
			}
		}

		return $thumb_size;
	}

	public function getItemLink($params) {
		$item_id = $params['is_featured'] ? $params['featured_project'] : get_the_ID();

		$portfolio_link_meta = get_post_meta( $item_id, 'qode_portfolio-external-link', true );
		$portfolio_link      = ! empty( $portfolio_link_meta ) ? $portfolio_link_meta : get_permalink( $item_id );

		return $portfolio_link;
	}

	public function getItemLinkTarget($params) {
		$item_id = $params['is_featured'] ? $params['featured_project'] : get_the_ID();

		$portfolio_link_meta   = get_post_meta( $item_id, 'qode_portfolio-external-link-target', true );
		$portfolio_link_target = ! empty( $portfolio_link_meta ) ? '_blank' : '_self';

		return $portfolio_link_target;
	}
}

\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new StockholmCorePortfolioListHorizontal() );
