<?php
/* Button shortcode */

if (!function_exists('button')) {
	function qbutton($atts, $content = null) {
		$args = array(
			"size"                      => "",
			"style"                     => "",
			"text"                      => "",
			"icon_pack"              	=> "",
			"fa_icon"                	=> "",
			"fe_icon"                	=> "",
			"linear_icon"               => "",
			"icon_color"                => "",
			"icon_size"                 => "",
			"link"                      => "",
			"target"                    => "_self",
			"color"                     => "",
			"hover_color"               => "",
			"background_color"			=> "",
			"hover_background_color"    => "",
			"border_color"              => "",
			"hover_border_color"        => "",
			"font_size"                 => "",
			"font_style"                => "",
			"font_weight"               => "",
			"letter_spacing"            => "",
			"text_align"                => "",
			"margin"					=> "",
			"border_radius"				=> "",
			'hover_animation'			=> "",
			'custom_class'				=> ""
		);
		
		$default_atts = array_merge($args, stockholm_qode_icon_collections()->getShortcodeParams());
		
		$params = shortcode_atts($default_atts, $atts);
		$params['content'] = $content;
		$params['default_atts'] = $default_atts;
		
		extract($params);
		
		return stockholm_qode_get_shortcode_template_part('templates/button', '_button', '', $params);
		
	}
	add_shortcode('qbutton', 'qbutton');
}

if ( ! function_exists( 'stockholm_qode_get_button_html' ) ) {
	/**
	 * Calls button shortcode with given parameters and returns it's output
	 *
	 * @param $params
	 *
	 * @return mixed|string
	 */
	function stockholm_qode_get_button_html( $params ) {
		$button_html = stockholm_qode_execute_shortcode( 'qbutton', $params );
		$button_html = str_replace( "\n", '', $button_html );

		return $button_html;
	}
}