<?php

class StockholmCoreElementorCircles extends \Elementor\Widget_Base{
    public function get_name() {
        return 'qode_circles';
    }

    public function get_title() {
        return esc_html__( 'Select Process', 'stockholm-core' );
    }

    public function get_icon() {
        return 'stockholm-elementor-custom-icon stockholm-elementor-circles';
    }

    public function get_categories() {
        return [ 'select' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'general',
            [
                'label' => esc_html__( 'General', 'stockholm-core' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'columns',
            [
                'label' => esc_html__( 'Columns', 'stockholm-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'three_columns' => esc_html__('Three', 'stockholm-core'),
                    'four_columns'  => esc_html__('Four', 'stockholm-core'),
                    'five_columns'  => esc_html__('Five', 'stockholm-core'),
                ],
                'default' => 'four_columns'
            ]
        );

        $this->add_control(
            'lines_between',
            [
                'label' => esc_html__( 'Lines Between Items?', 'stockholm-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    ''          => esc_html__('Default', 'stockholm-core'),
                    'no_line'   => esc_html__('No', 'stockholm-core'),
                    'with_line' => esc_html__('Yes', 'stockholm-core')
                ],
                'default' => 'no_line'
            ]
        );

        $this->add_control(
            'line_color',
            [
                'label' => esc_html__( 'Line Color', 'stockholm-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'condition' => [
                    'lines_between' => 'with_line'
                ]
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'type',
            [
                'label' => esc_html__( 'Type', 'stockholm-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'icon_type'  => esc_html__('Icon in Process', 'stockholm-core'),
                    'image_type' => esc_html__('Image', 'stockholm-core'),
                    'text_type'  => esc_html__('Text in Process', 'stockholm-core'),
                ],
                'default' => 'icon_type'
            ]
        );

        $repeater->add_control(
            'background_color',
            [
                'label' => esc_html__( 'Background Process Color', 'stockholm-core'),
                'type' => \Elementor\Controls_Manager::COLOR
            ]
        );

        $repeater->add_control(
            'background_transparency',
            [
                'label' => esc_html__( 'Background Process Transparency', 'stockholm-core'),
                'description' => esc_html__( 'Insert value between 0 and 1', 'stockholm-core'),
                'type' => \Elementor\Controls_Manager::TEXT
            ]
        );
	
	    $repeater->add_control(
		    'without_double_border',
		    [
			    'label' => esc_html__( 'Without outer border?', 'stockholm-core'),
			    'type' => \Elementor\Controls_Manager::SWITCHER,
			    'default' => 'yes'
		    ]
	    );

        $repeater->add_control(
            'border_color',
            [
                'label' => esc_html__( 'Border Process Color', 'stockholm-core'),
                'type' => \Elementor\Controls_Manager::COLOR
            ]
        );

        $repeater->add_control(
            'border_width',
            [
                'label' => esc_html__( 'Border Process Width', 'stockholm-core'),
                'type' => \Elementor\Controls_Manager::TEXT
            ]
        );
	
	    stockholm_qode_icon_collections()->getElementorParamsArray($repeater, array('type' => 'icon_type'), '', true);
	    
        $repeater->add_control(
            'size',
            [
                'label' => esc_html__( 'Size', 'stockholm-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                "description" => esc_html__( "Enter just number. Omit px", 'stockholm-core' ),
                'condition' => [
                    'type' => 'icon_type'
                ]
            ]
        );

        $repeater->add_control(
            'icon_color',
            [
                'label' => esc_html__( 'Icon Color', 'stockholm-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'condition' => [
                    'type' => 'icon_type'
                ],
            ]
        );

        $repeater->add_control(
            'image',
            [
                'label' => esc_html__( 'Image', 'stockholm-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'condition' => [
                    'type' => 'image_type'
                ],
            ]
        );

        $repeater->add_control(
            'text_in_circle',
            [
                'label' => esc_html__( 'Text in Process', 'stockholm-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'condition' => [
                    'type' => 'text_type'
                ],
            ]
        );

        $repeater->add_control(
            'text_in_circle_tag',
            [
                'label' => esc_html__( 'Text in Process Tag', 'stockholm-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => stockholm_qode_get_title_tag(true),
                'condition' => [
                    'text_in_circle!' => ''
                ],
                'default' => 'h3'
            ]
        );

        $repeater->add_control(
            'font_size',
            [
                'label' => esc_html__( 'Text in Process Size (px)', 'stockholm-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'condition' => [
                    'text_in_circle!' => ''
                ]
            ]
        );

        $repeater->add_control(
            'text_in_circle_color',
            [
                'label' => esc_html__( 'Text in Process Color', 'stockholm-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'condition' => [
                    'text_in_circle!' => ''
                ]
            ]
        );
        
        $repeater->add_control(
            'link',
            [
                'label' => esc_html__( 'Link', 'stockholm-core'),
                'type' => \Elementor\Controls_Manager::TEXT
            ]
        );

        $repeater->add_control(
            'link_target',
            [
                'label' => esc_html__( 'Link Target', 'stockholm-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => stockholm_qode_get_link_target_array(true),
                'default' => '_self',
                'condition' => [
                    'link!' => ''
                ]
            ]
        );

        $repeater->add_control(
            'title',
            [
                'label' => esc_html__( 'Title', 'stockholm-core'),
                'type' => \Elementor\Controls_Manager::TEXT
            ]
        );

        $repeater->add_control(
            'title_tag',
            [
                'label' => esc_html__( 'Title Tag', 'stockholm-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => stockholm_qode_get_title_tag(true),
                'condition' => [
                    'title!' => ''
                ]
            ]
        );

        $repeater->add_control(
            'title_color',
            [
                'label' => esc_html__( 'Title Color', 'stockholm-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'condition' => [
                    'title!' => ''
                ]
            ]
        );

        $repeater->add_control(
            'text',
            [
                'label' => esc_html__( 'Text', 'stockholm-core'),
                'type' => \Elementor\Controls_Manager::TEXTAREA
            ]
        );

        $repeater->add_control(
            'text_color',
            [
                'label' => esc_html__( 'Text Color', 'stockholm-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'condition' => [
                    'text!' => ''
                ]
            ]
        );

        $this->add_control(
            'circles',
            [
                'label' => esc_html__( 'Process Items', 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => esc_html__('Process Item'),
            ]
        );

        $this->end_controls_section();
    }

    protected function render(){
        $params = $this->get_settings_for_display();

        $styles = array();
	
	    $circle_holder_class = '';
	
	    if(isset($params['lines_between']) && $params['lines_between'] == 'with_line') {
		    $circle_holder_class = 'with_lines';
	    }

        if(!empty($params['line_color'])) {
            $styles[] = "border-color: ".$params['line_color'].";";
        }
        ?>
	
	    <div class="q_circles_shortcode">
	        <ul class="q_circles_holder <?php echo esc_attr( $params['columns'] ); ?> <?php echo esc_attr( $circle_holder_class ) ?>" <?php echo stockholm_qode_get_inline_style(implode(';',$styles)); ?>>
	
	            <?php
	
	            foreach ($params['circles'] as $circle){
	                $args = array(
	                    "type"                          => "",
	                    "background_color"              => "",
	                    "background_transparency"       => "",
	                    "border_color"                  => "",
	                    "border_width"                  => "",
	                    "icon"                          => "",
	                    "size"                          => "",
	                    "icon_color"                    => "",
	                    "image"                         => "",
	                    "text_in_circle"                => "",
	                    "text_in_circle_tag"            => "h3",
	                    "font_size"                     => "",
	                    "text_in_circle_color"          => "",
	                    "link"                          => "",
	                    "link_target"                   => "_self",
	                    "title"                         => "",
	                    "title_tag"                     => "h3",
	                    "title_color"                   => "",
	                    "text"                          => "",
	                    "text_color"                    => ""
	                );
	                $circle['args'] = $args;
	
	                if( ! empty( $circle['image'] ) ){
	                    $circle['image'] = $circle['image']['id'];
	                }
	
	                echo stockholm_qode_get_shortcode_template_part('templates/circle', '_circles', '', $circle);
	            }
	
	            ?>
	
	        </ul>
	    </div>

        <?php

    }
}

\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new StockholmCoreElementorCircles() );