<?php

class StockholmCoreElementorPieChartWithIcon extends \Elementor\Widget_Base{
    public function get_name() {
        return 'pie_chart_with_icon';
    }

    public function get_title() {
        return esc_html__( "Pie Chart With Icon", 'stockholm-core' );
    }

    public function get_icon() {
        return 'stockholm-elementor-custom-icon stockholm-elementor-pie-chart-with-icon';
    }

    public function get_categories() {
        return [ 'select' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'general',
            [
                'label' => esc_html__( 'General', 'stockholm-core' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'percent',
            [
                'label' => esc_html__( "Percentage", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => '25'
            ]
        );

        $this->add_control(
            'active_color',
            [
                'label' => esc_html__( "Bar Active Color", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::COLOR
            ]
        );

        $this->add_control(
            'noactive_color',
            [
                'label' => esc_html__( "Bar Inactive Color", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::COLOR
            ]
        );
	
	    $this->add_control(
		    'chart_width',
		    [
			    'label' => esc_html__( "Pie Chart Width (px)", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::TEXT
		    ]
	    );
	
	    $this->add_control(
		    'line_width',
		    [
			    'label' => esc_html__( "Pie Chart Line Width (px)", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::TEXT
		    ]
	    );
        
        $this->add_control(
            'title',
            [
                'label' => esc_html__( "Title", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::TEXT
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__( "Title Color", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'condition' => [
	                'title!' => ''
                ]
            ]
        );

        $this->add_control(
            'title_tag',
            [
                'label' => esc_html__( "Title Tag", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => stockholm_qode_get_title_tag( false ),
                'default' => 'h3',
                'condition' => [
	                'title!' => ''
                ]
            ]
        );
	
	    stockholm_qode_icon_collections()->getElementorParamsArray($this, '', '', true);
	
	    $this->add_control(
		    'icon_color',
		    [
			    'label' => esc_html__( "Icon Color", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::COLOR
		    ]
	    );
	    
        $this->add_control(
            'text',
            [
                'label' => esc_html__( "Text", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::TEXT
            ]
        );

        $this->add_control(
            'text_color',
            [
                'label' => esc_html__( "Text Color", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'condition' => [
	                'text!' => ''
                ]
            ]
        );

        $this->end_controls_section();
    }

    protected function render(){
        $params = $this->get_settings_for_display();
	
	    $params['icon'] = stockholm_qode_icon_collections()->getElementorIconFromIconPack( $params );

        echo stockholm_qode_get_shortcode_template_part('templates/pie-chart-with-icon', '_pie-chart-with-icon', '', $params);
    }

}

\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new StockholmCoreElementorPieChartWithIcon() );