<?php

class StockholmCoreElementorPieChart extends \Elementor\Widget_Base{
    public function get_name() {
        return 'pie_chart';
    }

    public function get_title() {
        return esc_html__( "Pie Chart", 'stockholm-core' );
    }

    public function get_icon() {
        return 'stockholm-elementor-custom-icon stockholm-elementor-pie-chart';
    }

    public function get_categories() {
        return [ 'select' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'general',
            [
                'label' => esc_html__( 'General', 'stockholm-core' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'percent',
            [
                'label' => esc_html__( "Percentage", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => '25'
            ]
        );
	
	    $this->add_control(
		    'show_percent_mark',
		    [
			    'label' => esc_html__( "Show Percentage Mark", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => [
			        "with_mark"    => esc_html__( "Yes", 'stockholm-core' ),
			        "without_mark" => esc_html__( "No", 'stockholm-core' )
			    ],
			    'default' => 'without_mark',
			    'condition' => [
				    'percent!' => ''
			    ]
		    ]
	    );

        $this->add_control(
            'percentage_color',
            [
                'label' => esc_html__( "Percentage Color", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'condition' => [
	                'percent!' => ''
                ]
            ]
        );

        $this->add_control(
            'percent_font_size',
            [
                'label' => esc_html__( "Percentage Font Size", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'condition' => [
	                'percent!' => ''
                ]
            ]
        );

        $this->add_control(
            'percent_font_weight',
            [
                'label' => esc_html__( "Percentage Font weight", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => stockholm_qode_get_font_weight_array( true ),
                'default' => '400',
                'condition' => [
	                'percent!' => ''
                ]
            ]
        );

        $this->add_control(
            'active_color',
            [
                'label' => esc_html__( "Bar Active Color", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::COLOR
            ]
        );

        $this->add_control(
            'noactive_color',
            [
                'label' => esc_html__( "Bar Noactive Color", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::COLOR
            ]
        );
	
	    $this->add_control(
		    'chart_width',
		    [
			    'label' => esc_html__( "Pie Chart Width (px)", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::TEXT,
		    ]
	    );
        
        $this->add_control(
            'line_width',
            [
                'label' => esc_html__( "Pie Chart Line Width (px)", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::TEXT,
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => esc_html__( "Title", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::TEXT,
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__( "Title Color", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::COLOR,
            ]
        );

        $this->add_control(
            'title_tag',
            [
                'label' => esc_html__( "Title Tag", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => stockholm_qode_get_title_tag( false ),
                'default' => 'h5'
            ]
        );

        $this->add_control(
            'text',
            [
                'label' => esc_html__( "Text", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::TEXT
            ]
        );

        $this->add_control(
            'text_color',
            [
                'label' => esc_html__( "Text Color", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::COLOR
            ]
        );
        
        $this->end_controls_section();
    }

    protected function render(){
        $params = $this->get_settings_for_display();

        echo stockholm_qode_get_shortcode_template_part('templates/pie-chart', '_pie-chart', '', $params);
    }

}

\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new StockholmCoreElementorPieChart() );