<?php

class StockholmCoreElementorCarousel extends \Elementor\Widget_Base{
    public function get_name() {
        return 'qode_carousel';
    }

    public function get_title() {
        return esc_html__( "Select Carousel", 'stockholm-core' );
    }

    public function get_icon() {
        return 'stockholm-elementor-custom-icon stockholm-elementor-carousel';
    }

    public function get_categories() {
        return [ 'select' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'general',
            [
                'label' => esc_html__( 'General', 'stockholm-core' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'carousel',
            [
                'label' => esc_html__( "Carousel Slider", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'options' => array_flip(stockholm_get_carousel_slider_array()),
				'render_type' => 'template'
            ]
        );
	
	    $this->add_control(
		    'carousel_type',
		    [
			    'label' => esc_html__( "Carousel Type", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => [
				    ''             => esc_html__( 'Default', 'stockholm-core' ),
				    'carousel_owl' => esc_html__( 'Draggable', 'stockholm-core' ),
			    ],
			    'default' => ''
		    ]
	    );

        $this->add_control(
            'items_visible',
            [
                'label' => esc_html__( "Items Visible", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    '2' => esc_html__( 'Two', 'stockholm-core' ),
                    '3' => esc_html__( 'Three', 'stockholm-core' ),
                    '4' => esc_html__( 'Four', 'stockholm-core' ),
                    '5' => esc_html__( 'Five', 'stockholm-core' ),
                    '6' => esc_html__( 'Six', 'stockholm-core' ),
                ],
//                'condition' => [
//                	'carousel_type' => ''
//                ],
                'default' => '5'
            ]
        );

        $this->add_control(
            'order_by',
            [
                'label' => esc_html__( "Order By", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'menu_order' => esc_html__( 'Menu Order', 'stockholm-core' ),
                    'title'      => esc_html__( 'Title', 'stockholm-core' ),
                    'date'       => esc_html__( 'Date', 'stockholm-core' ),
                ],
                'default' => 'date'
            ]
        );

        $this->add_control(
            'order',
            [
                'label' => esc_html__( "Order", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => stockholm_qode_get_query_order_array( true ),
                'default' => 'ASC'
            ]
        );

		$this->add_control(
			'stage_padding',
			[
				'label' => esc_html__( "Stage Padding", 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'description' =>  esc_html__( 'Padding left and right on stage (can see neighbours)', 'stockholm-core' ),
				'options' => stockholm_qode_get_yes_no_select_array(false),
				'default' => 'yes',
				'condition' => [
					'carousel_type' => 'carousel_owl'
				],
			]
		);

	    $this->add_control(
		    'show_navigation',
		    [
			    'label' => esc_html__( "Show navigation?", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => stockholm_qode_get_yes_no_select_array(false),
			    'default' => 'yes',
			    'condition' => [
				    'carousel_type' => ''
			    ],
		    ]
	    );
	
	    $this->add_control(
		    'show_draggable_navigation',
		    [
			    'label' => esc_html__( "Show navigation?", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => stockholm_qode_get_yes_no_select_array(false),
			    'default' => 'yes',
			    'condition' => [
				    'carousel_type' => 'carousel_owl'
			    ],
		    ]
	    );

	    $this->add_control(
		    'draggable_slider_speed',
		    [
			    'label' => esc_html__( "Autoplay speed (in miliseconds)", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::TEXT,
			    'default' => '5000',
			    'condition' => [
				    'carousel_type' => 'carousel_owl'
			    ],
		    ]
	    );
	    
        $this->add_control(
            'show_in_two_rows',
            [
                'label' => esc_html__( "Show Items In Two Rows?", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    ''    => esc_html__( 'No', 'stockholm-core' ),
                    'yes' => esc_html__( 'Yes', 'stockholm-core' ),
                ],
                'default' => ''
            ]
        );
	
	    $this->add_control(
		    'space_between',
		    [
			    'label' => esc_html__( "Space Between Items?", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => stockholm_qode_get_yes_no_select_array(false),
			    'default' => 'no'
		    ]
	    );
	
	    $this->add_control(
		    'hover_effect',
		    [
			    'label' => esc_html__( "Hover Effect", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => [
				    'second_image'    => esc_html__( 'Show second image', 'stockholm-core' ),
				    'overlay'         => esc_html__( 'Overlay', 'stockholm-core' ),
				    'disable'         => esc_html__( 'Disable', 'stockholm-core' )
			    ],
			    'default' => 'overlay'
		    ]
	    );
	
	    $this->add_control(
		    'on_click',
		    [
			    'label' => esc_html__( "On Click", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => [
				    'open_link'    => esc_html__( 'Open link', 'stockholm-core' ),
				    'prettyphoto'  => esc_html__( 'Open image in Prettyphoto', 'stockholm-core' )
			    ],
			    'default' => 'open_link',
			    'condition' => [
				    'hover_effect' => array( 'overlay', 'disable' )
			    ],
		    ]
	    );

        $this->end_controls_section();
    }

    protected function render(){
        $params = $this->get_settings_for_display();

        echo stockholm_qode_get_shortcode_template_part('templates/qode-carousel', '_qode-carousel', '', $params);
    }

}

\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new StockholmCoreElementorCarousel() );