<?php

namespace Stockholm\Shortcodes\ImageMarquee;

use Stockholm\Shortcodes\Lib\ShortcodeInterface;

class ImageMarquee implements ShortcodeInterface {
	private $base;
	
	public function __construct() {
		$this->base = 'qode_image_marquee';
		
		add_action( 'vc_before_init', array( $this, 'vcMap' ) );
	}
	
	public function getBase() {
		return $this->base;
	}
	
	public function vcMap() {
		if ( function_exists( 'vc_map' ) ) {
			vc_map(
				array(
					'name'                      => esc_html__( 'Image Marquee', 'stockholm-core' ),
					'base'                      => $this->getBase(),
					'category'                  => esc_html__( 'by SELECT', 'stockholm-core' ),
					'icon'                      => 'icon-wpb-image-marquee extended-custom-icon-qode',
					'allowed_container_element' => 'vc_row',
					'params'                    => array(
							array(
							'type'        => 'attach_image',
							'param_name'  => 'image',
							'heading'     => esc_html__( 'Image', 'stockholm-core' ),
							'description' => esc_html__( 'Select image from media library', 'stockholm-core' )
						),
					)
				)
			);
		}
	}
	
	public function render( $atts, $content = null ) {
		$args   = array(
			'image' => '',
		);
		
		$params = shortcode_atts( $args, $atts );
		$html = stockholm_qode_get_shortcode_template_part( 'templates/image-marquee-template', 'image-marquee', '', $params );
		
		return $html;
	}
}