<?php

class StockholmCoreElementorInteractiveImage extends \Elementor\Widget_Base{
    public function get_name() {
        return 'interactive_image';
    }

    public function get_title() {
        return esc_html__('Interactive Image', 'stockholm-core');
    }

    public function get_icon() {
        return 'stockholm-elementor-custom-icon stockholm-elementor-interactive-image';
    }

    public function get_categories() {
        return [ 'select' ];
    }

    protected function _register_controls(){
        $this->start_controls_section(
            'general',
            [
                'label' => esc_html__( 'General', 'stockholm-core' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'image',
            [
                'label' => esc_html__('Image', 'stockholm-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'stockholm-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
            ]
        );
	
	    $this->add_control(
		    'title_tag',
		    [
			    'label' => esc_html__('Title Tag', 'stockholm-core'),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => stockholm_qode_get_title_tag(false),
			    'default' => 'h2'
		    ]
	    );
	
	    $this->add_control(
		    'text',
		    [
			    'label' => esc_html__('Text', 'stockholm-core'),
			    'type' => \Elementor\Controls_Manager::TEXTAREA,
		    ]
	    );
	
	    $this->add_control(
		    'link',
		    [
			    'label' => esc_html__('Button Link', 'stockholm-core'),
			    'type' => \Elementor\Controls_Manager::TEXT,
		    ]
	    );
	
	    $this->add_control(
		    'link_target',
		    [
			    'label' => esc_html__('Button Target', 'stockholm-core'),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => stockholm_qode_get_link_target_array()
		    ]
	    );
	
	    $this->add_control(
		    'link_text',
		    [
			    'label' => esc_html__('Button Text', 'stockholm-core'),
			    'type' => \Elementor\Controls_Manager::TEXT,
		    ]
	    );
	
	    $this->add_control(
		    'link_style',
		    [
			    'label' => esc_html__('Button Style', 'stockholm-core'),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => [
				    ''           => esc_html__( 'Default', 'stockholm-core' ),
				    'white'      => esc_html__( 'White', 'stockholm-core' ),
				    'underlined' => esc_html__( 'Underlined', 'stockholm-core' )
			    ]
		    ]
	    );
	
	    $this->add_control(
		    'active',
		    [
			    'label' => esc_html__('Set as active', 'stockholm-core'),
			    'type' => \Elementor\Controls_Manager::SWITCHER,
		    ]
	    );

		$this->add_control(
			'content_in_center',
			[
				'label' => esc_html__('Content in center', 'stockholm-core'),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => stockholm_qode_get_yes_no_select_array(),
				'default' => 'no'
			]
		);
	    
        $this->end_controls_section();
    }

    protected function render(){
        $params = $this->get_settings_for_display();

        if( ! empty( $params['image'] ) ){
	        $params['image_src']    = wp_get_attachment_url( $params['image']['id'] );
        }
	    $params['holderClasses'] = $this->getHolderClasses( $params );
        
        echo stockholm_qode_get_shortcode_template_part('templates/interactive-image', 'interactive-image', '', $params);
    }
	
	private function getHolderClasses( $params ) {
		$classes = '';

		if ( $params['active'] == 'yes' ) {
			$classes .= ' active';
		}

		if ( $params['content_in_center'] == 'yes' ) {
			$classes .= ' qode-content-in-center';
		}
		
		return $classes;
	}
}

\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new StockholmCoreElementorInteractiveImage() );