<?php

class StockholmCoreElementorParallaxHolder extends \Elementor\Widget_Base{
    public function get_name() {
        return 'qode_parallax_holder';
    }

    public function get_title() {
        return esc_html__( "Parallax Holder", 'stockholm-core' );
    }

    public function get_icon() {
        return 'stockholm-elementor-custom-icon stockholm-elementor-parallax-holder';
    }

    public function get_categories() {
        return [ 'select' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'general',
            [
                'label' => esc_html__( 'General', 'stockholm-core' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
	
	    $this->add_control(
		    'content',
		    [
			    'label' => esc_html__( 'Content', 'stockholm-core'),
			    'description' => esc_html__('Enter content', 'stockholm-core'),
			    'type' => \Elementor\Controls_Manager::WYSIWYG
		    ]
	    );
        
        $this->add_control(
            'y_axis_translation',
            [
                'label' => esc_html__( "Y Axis Translation", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => esc_html__('Enter the value in pixels. Negative value changes parallax direction.', 'stockholm-core'),
	            'default' => '-200'
            ]
        );
	    stockholm_core_generate_elementor_templates_control( $this, array('content' => '') );
        
        
        $this->end_controls_section();
    }

    protected function render(){
        $params = $this->get_settings_for_display();
	
	    $html= '';
	    $y_absolute = intval($params['y_axis_translation']);
	    $smoothness = 20; //1 is for linear, non-animated parallax
	
	    $parallax = '{&quot;y&quot;: '.$y_absolute.', &quot;smoothness&quot;: '.$smoothness.'}';
	
	    if ( empty($params['content']) ) {
		    $params['content'] = Elementor\Plugin::instance()->frontend->get_builder_content_for_display($params['template_id']);
	    }
	    
	    ?>
	
	    <div class="qode-parallax-holder" data-parallax="<?php echo wp_kses_post($parallax); ?>">
	        <?php echo do_shortcode($params['content']); ?>
	    </div>
	
	    <?php
    }
}

\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new StockholmCoreElementorParallaxHolder() );