<?php
$custom_portfolio_link = get_post_meta(get_the_ID(), 'qode_portfolio-external-link', true);
$params['portfolio_link'] = $custom_portfolio_link != "" ? $custom_portfolio_link : get_permalink();

if(get_post_meta(get_the_ID(), 'qode_portfolio-external-link-target', true) != ""){
    $custom_portfolio_link_target = get_post_meta(get_the_ID(), 'qode_portfolio-external-link-target', true);
} else {
    $custom_portfolio_link_target = '_blank';
}
$params['target'] = $custom_portfolio_link != "" ? $custom_portfolio_link_target : '_self'; ?>

<article class="qode-pl-item <?php echo implode(' ',$item_classes); ?>" data-img-index="<?php echo esc_attr($counter); ?>">
    <div class="qode-pl-item-inner">
        <div class='portfolio_description <?php echo esc_html($portfolio_description_class); ?>' <?php echo esc_html($portfolio_box_style); ?>>
            <?php
            echo stockholm_qode_get_shortcode_template_part('templates/parts/title', 'portfolio-list', 'with-link', $params);

            echo stockholm_qode_get_shortcode_template_part('templates/parts/read-more', 'portfolio-list', '', $params);
            ?>
        </div>
        <div class='image_holder'>
            <?php echo stockholm_qode_get_shortcode_template_part('templates/parts/image', 'portfolio-list', '', $params); ?>

            <?php if($disable_link != "yes"){ ?>
                <a class='portfolio_link_class' href='<?php echo esc_url($params['portfolio_link']); ?>' target='<?php echo esc_attr($params['target']); ?>'></a>
            <?php } ?>

        </div>
    </div>
</article>
<?php //this line is because of the space between items ?>