<?php
namespace Stockholm\Shortcodes\WorkflowItem;

use Stockholm\Shortcodes\Lib\ShortcodeInterface;

/**
 * class Workflow
 */
class WorkflowItem implements ShortcodeInterface {
    /**
     * @var string
     */
    private $base;

    function __construct() {
        $this->base = 'qode_workflow_item';
        add_action('vc_before_init', array($this, 'vcMap'));
    }

    public function getBase() {
        return $this->base;
    }

    public function vcMap() {

        vc_map(array(
            "name"                    => esc_html__('Workflow Item', 'stockholm-core'),
            "base"                    => $this->base,
            "as_child"                => array('only' => 'qode_workflow'),
            'category'                => esc_html__('by SELECT', 'stockholm-core'),
            "icon"                    => "icon-wpb-workflow-item extended-custom-icon-qode",
            "show_settings_on_create" => true,
            'params'                  => array_merge(
                array(
                    array(
                        'type'        => 'textfield',
                        'heading'     => esc_html__('Title', 'stockholm-core'),
                        'param_name'  => 'title',
                        'admin_label' => true,
                        'description' => esc_html__('Enter workflow item title.', 'stockholm-core')
                    ),
					array(
						'type'			=> 'dropdown',
						'heading'		=> esc_html__('Title Tag', 'stockholm-core'),
						'param_name'	=> 'title_tag',
						'value' => array(
							'' => '',
							'h2' => 'h2',
							'h3' => 'h3',
							'h4' => 'h4',
							'h5' => 'h5',
							'h6' => 'h6',
                            'p' => 'p'
						),
						'group'			=> esc_html__('Design Group', 'stockholm-core')
					),
                    array(
                        'type'        => 'textfield',
                        'heading'     => esc_html__('Subtitle', 'stockholm-core'),
                        'param_name'  => 'subtitle',
                        'admin_label' => true,
                        'description' => esc_html__('Enter workflow item subtitle.', 'stockholm-core')
                    ),
					array(
						'type'			=> 'dropdown',
						'heading'		=> esc_html__('Subtitle Tag', 'stockholm-core'),
						'param_name'	=> 'subtitle_tag',
						'value' => array(
							'' => '',
							'h2' => 'h2',
							'h3' => 'h3',
							'h4' => 'h4',
							'h5' => 'h5',
							'h6' => 'h6',
                            'p' => 'p'
						),
						'group'			=> esc_html__('Design Group', 'stockholm-core')
					),
                    array(
                        'type'        => 'textarea',
                        'heading'     => esc_html__('Text', 'stockholm-core'),
                        'param_name'  => 'text',
                        'description' => esc_html__('Enter workflow item text.', 'stockholm-core')
                    ),
                    array(
                        'type'        => 'attach_image',
                        'heading'     => esc_html__('Image', 'stockholm-core'),
                        'param_name'  => 'image',
                        'description' => esc_html__('Insert workflow item image.', 'stockholm-core')
                    ),
                    array(
                        'type'        => 'dropdown',
                        'heading'     => esc_html__('Image alignment', 'stockholm-core'),
                        'param_name'  => 'image_alignment',
                        'admin_label' => true,
                        'value'       => array(
                            esc_html__('Center', 'stockholm-core') => 'center',
                            esc_html__('Left', 'stockholm-core')   => 'left',
                            esc_html__('Right', 'stockholm-core')  => 'right'
                        )
                    ),
                    array(
                        'type'        => 'textfield',
                        'heading'     => esc_html__('Image Title', 'stockholm-core'),
                        'param_name'  => 'image_title',
                        'admin_label' => true,
                        'description' => esc_html__('Enter workflow item image title.', 'stockholm-core')
                    ),
                    array(
                        'type'			=> 'dropdown',
                        'heading'		=> esc_html__('Image Title Tag', 'stockholm-core'),
                        'param_name'	=> 'image_title_tag',
                        'value' => array(
                            '' => '',
                            'h2' => 'h2',
                            'h3' => 'h3',
                            'h4' => 'h4',
                            'h5' => 'h5',
                            'h6' => 'h6',
                            'p' => 'p'
                        ),
                        'group'			=> esc_html__('Design Group', 'stockholm-core')
                    ),
                    array(
                        'type'        => 'textfield',
                        'heading'     => esc_html__('Image Subtitle', 'stockholm-core'),
                        'param_name'  => 'image_subtitle',
                        'admin_label' => true,
                        'description' => esc_html__('Enter workflow item image subtitle.', 'stockholm-core')
                    ),
                    array(
                        'type'			=> 'dropdown',
                        'heading'		=> esc_html__('Image Subtitle Tag', 'stockholm-core'),
                        'param_name'	=> 'image_subtitle_tag',
                        'value' => array(
                            '' => '',
                            'h2' => 'h2',
                            'h3' => 'h3',
                            'h4' => 'h4',
                            'h5' => 'h5',
                            'h6' => 'h6',
                            'p' => 'p'
                        ),
                        'group'			=> esc_html__('Design Group', 'stockholm-core')
                    ),
                    array(
                        'type'        => 'colorpicker',
                        'heading'     => esc_html__('Circle border color', 'stockholm-core'),
                        'param_name'  => 'circle_border_color',
                        'description' => esc_html__('Pick a color for the circle border color.', 'stockholm-core'),
						'group'		  => esc_html__('Design Group', 'stockholm-core')
                    ),
                    array(
                        'type'        => 'colorpicker',
                        'heading'     => esc_html__('Circle background color', 'stockholm-core'),
                        'param_name'  => 'circle_background_color',
                        'description' => esc_html__('Pick a color for the circle background color.', 'stockholm-core'),
						'group'		  => esc_html__('Design Group', 'stockholm-core')
                    ),
                )
            )
        ));
    }

    public function render($atts, $content = null) {
        $default_atts = (array(
            'title'                   => '',
            'title_tag'				  => 'h3',
            'subtitle'                => '',
            'subtitle_tag'			  => 'h6',
            'text'                    => '',
            'image'                   => '',
            'image_alignment'         => 'center',
            'image_title'             => '',
            'image_title_tag'         => 'h3',
            'image_subtitle'          => '',
            'image_subtitle_tag'      => 'h6',
            'circle_border_color'     => '',
            'circle_background_color' => '',
        ));
        $params       = shortcode_atts($default_atts, $atts);
        $style_params = $this->getStyleProperties($params);
        $params       = array_merge($params, $style_params);
        extract($params);

        $output = '';
        $output .= stockholm_qode_get_shortcode_template_part('templates/workflow-item-template', 'workflow', '', $params);

        return $output;
    }

    /**
     * Generates circle line color
     *
     * @param $params
     *
     * @return array
     */

    private function getStyleProperties($params) {

        $style                            = array();
        $style['circle_border_color']     = '';
        $style['circle_background_color'] = '';
        $style['line_color']              = '';

        if($params['circle_border_color'] !== '') {
            $style['circle_border_color'] = 'border-color:'.$params['circle_border_color'].';';
        }
        if($params['circle_background_color'] !== '') {
            $style['circle_background_color'] = 'background-color:'.$params['circle_background_color'].';';
            $style['line_color']              = 'background-color:'.$params['circle_background_color'].';';
        }

        return $style;
    }
}
