<?php

class StockholmCoreElementorProgressBarIcon extends \Elementor\Widget_Base{
    public function get_name() {
        return 'progress_bar_icon';
    }

    public function get_title() {
        return esc_html__( 'Progress Bar Icon', 'stockholm-core' );
    }

    public function get_icon() {
        return 'stockholm-elementor-custom-icon stockholm-elementor-progress-bar-icon';
    }

    public function get_categories() {
        return [ 'select' ];
    }

    protected function _register_controls() {

		$this->start_controls_section(
            'general',
            [
                'label' => esc_html__( 'General', 'stockholm-core' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

		$this->add_control(
			'icons_number',
			[
				'label' => esc_html__( 'Number of Icons', 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'active_number',
			[
				'label' => esc_html__( 'Number of Active Icons', 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'type',
			[
				'label' => esc_html__( 'Type', 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'normal' => esc_html__( 'Normal', 'stockholm-core' ),
					'circle' => esc_html__( 'Circle', 'stockholm-core' ),
					'square' => esc_html__( 'Square', 'stockholm-core' )
				),
				'default' => 'normal'
			]
		);
	
	    stockholm_qode_icon_collections()->getElementorParamsArray($this, '', '', true);

		$this->add_control(
			'size',
			[
				'label' => esc_html__( 'Size', 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'tiny'			=> esc_html__( 'Tiny', 'stockholm-core' ),
					'small'			=> esc_html__( 'Small', 'stockholm-core' ),
					'medium'		=> esc_html__( 'Medium', 'stockholm-core' ),
					'large'			=> esc_html__( 'Large', 'stockholm-core' ),
					'very_large'	=> esc_html__( 'Very Large', 'stockholm-core' )
				),
				'default' => 'tiny'
			]
		);
		
		$this->add_control(
			'icon_color',
			[
				'label' => esc_html__( 'Icon Color', 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::COLOR
			]
		);

		$this->add_control(
			'icon_active_color',
			[
				'label' => esc_html__( 'Icon Active Color', 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::COLOR
			]
		);

		$this->add_control(
			'background_color',
			[
				'label' => esc_html__( 'Background Color', 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::COLOR
			]
		);

		$this->add_control(
			'background_active_color',
			[
				'label' => esc_html__( 'Background Active Color', 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::COLOR
			]
		);

		$this->add_control(
			'border_color',
			[
				'label' => esc_html__( 'Border Color', 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'description' => esc_html__( 'Only for Square and Circle type', 'stockholm-core' ),
				'condition' => [
					'type' => ['square', 'circle']
				]
			]
		);

		$this->add_control(
			'border_active_color',
			[
				'label' => esc_html__( '"Border Active Color', 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'description' => esc_html__( 'Only for Square and Circle type', 'stockholm-core' ),
				'condition' => [
					'type' => ['square', 'circle']
				]
			]
		);
		
	    $this->end_controls_section();
    }

    protected function render(){
        $params = $this->get_settings_for_display();
	
	    $params['icon'] = stockholm_qode_icon_collections()->getElementorIconFromIconPack( $params );

        echo stockholm_qode_get_shortcode_template_part('templates/progress-bar-icon', '_progress-bar-icon', '', $params);
    }

}

\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new StockholmCoreElementorProgressBarIcon() );