<?php

class StockholmCoreElementorSocialIcons extends \Elementor\Widget_Base{
    public function get_name() {
        return 'social_icons';
    }

    public function get_title() {
        return esc_html__( 'Social Icons', 'stockholm-core' );
    }

    public function get_icon() {
        return 'stockholm-elementor-custom-icon stockholm-elementor-social-icons';
    }

    public function get_categories() {
        return [ 'select' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'general',
            [
                'label' => esc_html__( 'General', 'stockholm-core' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

	    $this->add_control(
		    'type',
		    [
			    'label' => esc_html__( 'Type', 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => array(
				    'normal_social'	=> esc_html__( 'Normal', 'stockholm-core' ),
				    'circle_social'	=> esc_html__( 'Circle', 'stockholm-core' ),
				    'square_social'	=> esc_html__( 'Square', 'stockholm-core' )
			    ),
				'default' => 'normal_social'
		    ]
	    );
	    
	    stockholm_qode_icon_collections()->getSocialElementorParamsArray($this, array(),'',false,array('linear_icons'));
	    
		$this->add_control(
			'size',
			[
				'label' => esc_html__( 'Size', 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'tiny'	    => esc_html__( 'Tiny', 'stockholm-core' ),
					'small'	    => esc_html__( 'Small', 'stockholm-core' ),
					'medium'	=> esc_html__( 'Medium', 'stockholm-core' ),
					'large'	    => esc_html__( 'Large', 'stockholm-core' ),
					'huge'	    => esc_html__( 'Huge', 'stockholm-core' )
				),
				'default' => 'medium',
			]
		);
		
		$this->add_control(
			'link',
			[
				'label' => esc_html__( 'Link', 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'target',
			[
				'label' => esc_html__( 'Target', 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => stockholm_qode_get_link_target_array(),
				'default' => '_self'
			]
		);

		
		$this->add_control(
			'icon_color',
			[
				'label' => esc_html__( 'Icon Color', 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::COLOR
			]
		);
	
	    $this->add_control(
		    'background_color',
		    [
			    'label' => esc_html__( 'Background Color', 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::COLOR,
			    'condition' => [
				    'type' => array('circle_social', 'square_social')
			    ]
		    ]
	    );
	
	    $this->add_control(
		    'border_color',
		    [
			    'label' => esc_html__( 'Border Color', 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::COLOR,
			    'condition' => [
				    'type' => array( 'circle_social', 'square_social' )
			    ]
		    ]
	    );
	    
		$this->add_control(
			'icon_hover_color',
			[
				'label' => esc_html__( 'Icon Hover Color', 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::COLOR
			]
		);
		
		$this->add_control(
			'background_hover_color',
			[
				'label' => esc_html__( 'Background Hover Color', 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'type' => array( 'circle_social', 'square_social' )
				]
			]
		);
		
		$this->add_control(
			'border_hover_color',
			[
				'label' => esc_html__( 'Border Hover Color', 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'type' => array( 'circle_social', 'square_social' )
				]
			]
		);
		
		$this->end_controls_section();
    }

    protected function render(){
        $params = $this->get_settings_for_display();
        
	    $params['icon'] = stockholm_qode_icon_collections()->getElementorIconFromIconPack( $params );
	
	    echo stockholm_qode_get_shortcode_template_part('templates/social-icons', '_social-icon', '', $params);
    }

}

\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new StockholmCoreElementorSocialIcons() );