<?php

class StockholmCoreElementorVerticalSplitSlider extends \Elementor\Widget_Base{
    public function get_name() {
        return 'qode_vertical_split_slider';
    }

    public function get_title() {
        return esc_html__( 'Qode Vertical Split Slider', 'stockholm-core' );
    }

    public function get_icon() {
        return 'bridge-elementor-custom-icon bridge-elementor-vertical-split-slider';
    }

    public function get_categories() {
        return [ 'qode' ];
    }

    public static function get_templates() {
        return Elementor\Plugin::instance()->templates_manager->get_source( 'local' )->get_items();
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'general',
            [
                'label' => esc_html__( 'General', 'stockholm-core' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'nav_position',
            [
                'label' => esc_html__( 'Navigation Position', 'stockholm-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => array(
                    'left' => esc_html__('Left', 'select-core'),
                    'right' => esc_html__('Right', 'select-core'),
                ),
                'default' => 'left'
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'left_panel',
            [
                'label' => esc_html__( 'Left Sliding Panel', 'stockholm-core' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'background_color',
            [
                'label' => esc_html__( 'Background Color', 'stockholm-core'),
                'type' => \Elementor\Controls_Manager::COLOR
            ]
        );

        $repeater->add_control(
            'background_image',
            [
                'label' => esc_html__( 'Background Image', 'stockholm-core'),
                'type' => \Elementor\Controls_Manager::MEDIA
            ]
        );

        $repeater->add_control(
            'item_padding',
            [
                'label' => esc_html__( 'Padding left/right', 'stockholm-core'),
                'type' => \Elementor\Controls_Manager::TEXT
            ]
        );

        $repeater->add_control(
            'aligment',
            [
                'label' => esc_html__( "Content Aligment", 'stockholm-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'left' => esc_html__('Left', 'stockholm-core'),
                    'right' => esc_html__('Right', 'stockholm-core'),
                    'center' => esc_html__('Center', 'stockholm-core'),
                ],
                'default' => 'left'
            ]
        );

        $repeater->add_control(
            'header_style',
            [
                'label' => esc_html__( 'Header/Bullets Style', 'stockholm-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    '' => '',
                    'light' => esc_html__('Light', 'stockholm-core'),
                    'dark' => esc_html__('Dark', 'stockholm-core')
                ],
                'default' => 'left'
            ]
        );

        $repeater->add_control(
            'item_link',
            [
                'label' => esc_html__( 'Item Link', 'stockholm-core'),
                'type' => \Elementor\Controls_Manager::TEXT
            ]
        );

        stockholm_core_generate_elementor_templates_control( $repeater );

        $this->add_control(
            'left_sliding_items',
            [
                'label' => esc_html__( 'Left Sliding Items', 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => esc_html__('Left Sliding Item'),
            ]
        );


        $this->end_controls_section();

        $this->start_controls_section(
            'right_panel',
            [
                'label' => esc_html__( 'Right Sliding Panel', 'stockholm-core' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'background_color',
            [
                'label' => esc_html__( 'Background Color', 'stockholm-core'),
                'type' => \Elementor\Controls_Manager::COLOR
            ]
        );

        $repeater->add_control(
            'background_image',
            [
                'label' => esc_html__( 'Background Image', 'stockholm-core'),
                'type' => \Elementor\Controls_Manager::MEDIA
            ]
        );

        $repeater->add_control(
            'item_padding',
            [
                'label' => esc_html__( 'Padding left/right', 'stockholm-core'),
                'type' => \Elementor\Controls_Manager::TEXT
            ]
        );

        $repeater->add_control(
            'aligment',
            [
                'label' => esc_html__( "Content Alignment", 'stockholm-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'left' => esc_html__('Left', 'stockholm-core'),
                    'right' => esc_html__('Right', 'stockholm-core'),
                    'center' => esc_html__('Center', 'stockholm-core'),
                ],
                'default' => 'left'
            ]
        );

        $repeater->add_control(
            'header_style',
            [
                'label' => esc_html__( 'Header/Bullets Style', 'stockholm-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    '' => '',
                    'light' => esc_html__('Light', 'stockholm-core'),
                    'dark' => esc_html__('Dark', 'stockholm-core')
                ],
                'default' => ''
            ]
        );

        $repeater->add_control(
            'item_link',
            [
                'label' => esc_html__( 'Item Link', 'stockholm-core'),
                'type' => \Elementor\Controls_Manager::TEXT
            ]
        );

        stockholm_core_generate_elementor_templates_control( $repeater );

        $this->add_control(
            'right_sliding_items',
            [
                'label' => esc_html__( 'Right Sliding Items', 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => esc_html__('Right Sliding Item'),
            ]
        );


        $this->end_controls_section();
    }

    protected function render(){
        $params = $this->get_settings_for_display();
        $nav_position = ! empty( $params['nav_position'] ) ? $params['nav_position'] : 'left';
        ?>

        <div class="vertical_split_slider" data-disable-header-skin-change="no" data-nav-position="<?php echo esc_attr( $nav_position ); ?>">
            <div class="ms-left">
                <?php if( is_array( $params['left_sliding_items'] ) && count( $params['left_sliding_items'] ) > 0 ) {
                    foreach ($params['left_sliding_items'] as $left_sliding_item) {
                        if( ! empty( $left_sliding_item['template_id'] ) ){
                            $left_sliding_item['content'] = Elementor\Plugin::instance()->frontend->get_builder_content_for_display($left_sliding_item['template_id']);
                        } else{
                            $left_sliding_item['content'] = '';
                        }
                        $left_sliding_item['background_image'] = ! empty( $left_sliding_item['background_image']['id'] ) ? $left_sliding_item['background_image']['id'] : '';
                        echo stockholm_qode_get_shortcode_template_part('templates/vertical-split-slider-item', '_vertical-split-slider-e', '', $left_sliding_item);
                    }
                } else{
                    //render even empty section so Vertical Split Slider is proprely initialized
                    echo stockholm_qode_get_shortcode_template_part('templates/vertical-split-slider-item', '_vertical-split-slider-e', '', array());
                } ?>
            </div>
            <div class="ms-right">
                <?php if( is_array( $params['right_sliding_items'] ) && count( $params['right_sliding_items'] ) > 0 ) {
                    foreach ($params['right_sliding_items'] as $right_sliding_item) {
                        if( ! empty( $right_sliding_item['template_id'] ) ){
                            $right_sliding_item['content'] = Elementor\Plugin::instance()->frontend->get_builder_content_for_display($right_sliding_item['template_id']);
                        } else{
                            $right_sliding_item['content'] = '';
                        }
                        $right_sliding_item['background_image'] = ! empty( $right_sliding_item['background_image']['id'] ) ? $right_sliding_item['background_image']['id'] : '' ;
                        echo stockholm_qode_get_shortcode_template_part('templates/vertical-split-slider-item', '_vertical-split-slider-e', '', $right_sliding_item);
                    }
                } else{
                    //render even empty section so Vertical Split Slider is proprely initialized
                    echo stockholm_qode_get_shortcode_template_part('templates/vertical-split-slider-item', '_vertical-split-slider-e', '', array());
                } ?>
            </div>
        </div>

        <?php
    }

}

\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new StockholmCoreElementorVerticalSplitSlider() );
