<?php

class StockholmCoreElementorContentSlider extends \Elementor\Widget_Base{
	public function get_name() {
		return 'content_slider';
	}
	
	public function get_title() {
		return esc_html__( 'Content Slider', 'stockholm-core' );
	}
	
	public function get_icon() {
		return 'stockholm-elementor-custom-icon stockholm-elementor-content-slider';
	}
	
	public function get_categories() {
		return [ 'select' ];
	}
	
	public static function get_templates() {
		return Elementor\Plugin::instance()->templates_manager->get_source( 'local' )->get_items();
	}
	
	protected function _register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'stockholm-core' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
			'animation_speed',
			[
				'label' => esc_html__('Animation speed', 'stockholm-core'),
				'description' => esc_html__('Speed of slide animation in miliseconds', 'stockholm-core'),
				'type' => \Elementor\Controls_Manager::TEXT
			]
		);
		
		$this->add_control(
			'navigation_arrows',
			[
				'label' => esc_html__('Show Navigation Arrows', 'stockholm-core'),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => stockholm_qode_get_yes_no_select_array(false,false),
				'default' => 'no'
			]
		);
		
		$repeater = new \Elementor\Repeater();
		
		$repeater->add_control(
			'content',
			[
				'label' => esc_html__( 'Content', 'stockholm-core'),
				'description' => esc_html__('Enter content of slide.', 'stockholm-core'),
				'type' => \Elementor\Controls_Manager::WYSIWYG
			]
		);
		
		stockholm_core_generate_elementor_templates_control( $repeater, array('content' => '') );
		
		$this->add_control(
			'content_slider_items',
			[
				'label' => esc_html__( 'Content Slider Items', 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => esc_html__('Content Slider Item'),
			]
		);
		
		$this->end_controls_section();
	}
	
	protected function render(){
		$params = $this->get_settings_for_display();
		$data_attr = $this->getDataParams( $params );
		
		?>
		
		<div class="qode-content-slider">
			<div class="qode-content-slider-slides qode-owl-slider" <?php echo stockholm_qode_get_inline_attrs( $data_attr ); ?>>
				<?php foreach ($params['content_slider_items'] as $content_slider_item) {
					
					if ( empty($content_slider_item['content']) ) {
						$content_slider_item['content'] = Elementor\Plugin::instance()->frontend->get_builder_content_for_display($content_slider_item['template_id']);
					}
					
					echo stockholm_qode_get_shortcode_template_part('templates/content-slide-template', 'content-slider', '', $content_slider_item);
				}
				?>
			</div>
		</div>
		
		<?php
	}
	
	
	private function getDataParams( $params ) {
		$data_attr = array();
		
		if ( ! empty( $params['animation_speed'] ) ) {
			$data_attr['data-slider-speed-animation'] = $params['animation_speed'];
		}
		
		if ( ! empty( $params['navigation_arrows'] ) ) {
			$data_attr['data-enable-navigation'] = $params['navigation_arrows'];
		}
		
		if ( ! empty( $params['pagination_bullets'] ) ) {
			$data_attr['data-pagination'] = $params['pagination_bullets'];
		}
		
		return $data_attr;
	}
}

\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new StockholmCoreElementorContentSlider() );