<?php

class StockholmCoreHorizontalyScrollingPortfolioList extends \Elementor\Widget_Base{
    public function get_name() {
        return 'qode_horizontaly_scrolling_portfolio_list';
    }

    public function get_title() {
        return esc_html__( "Horizontally Scrolling Portfolio List", 'stockholm-core' );
    }

    public function get_icon() {
        return 'stockholm-elementor-custom-icon stockholm-elementor-horizontally-scrolling-portfolio-list';
    }

    public function get_categories() {
        return [ 'select' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'general',
            [
                'label' => esc_html__( 'General', 'stockholm-core' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'number_of_items',
            [
                'label' => esc_html__( 'Number of Portfolios Per Page', 'stockholm-core' ),
                'description' => esc_html__( 'Set number of items for your portfolio list. Enter -1 to show all.', 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => '-1'
            ]
        );

        $this->add_control(
            'image_proportions',
            [
                'label' => esc_html__( 'Image Proportions', 'stockholm-core' ),
                'description' => esc_html__( 'Set image proportions for your portfolio list.', 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'full' => esc_html__( 'Original', 'stockholm-core' ),
                    'square' => esc_html__( 'Square', 'stockholm-core' ),
                    'landscape' => esc_html__( 'Landscape', 'stockholm-core' ),
                    'portrait' => esc_html__( 'Portrait', 'stockholm-core' ),
                    'medium' => esc_html__( 'Medium', 'stockholm-core' ),
                    'large' => esc_html__( 'Large', 'stockholm-core' ),
                ],
                'default' => 'full'
            ]
        );

        $this->add_control(
            'custom_project',
            [
                'label' => esc_html__( 'Enable Info Panel Intro', 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => stockholm_qode_get_yes_no_select_array(false, false),
                'default' => 'no'
            ]
        );

        $this->add_control(
            'custom_project_subtitle',
            [
                'label' => esc_html__( 'Info Panel Subtitle', 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'condition' => [
                    'custom_project' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'custom_project_subtitle_tag',
            [
                'label' => esc_html__( 'Info Panel Subtitle Title Tag', 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => stockholm_qode_get_title_tag(),
                'default' => 'h6',
                'condition' => [
                    'custom_project' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'custom_project_title',
            [
                'label' => esc_html__( 'Info Panel Title', 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'condition' => [
                    'custom_project' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'custom_project_title_tag',
            [
                'label' => esc_html__( 'Info Panel Title Tag', 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => stockholm_qode_get_title_tag(),
                'default' => 'h2',
                'condition' => [
                    'custom_project' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'custom_project_bg_color',
            [
                'label' => esc_html__( 'Info Panel Background Color', 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'condition' => [
                    'custom_project' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'category',
            [
                'label' => esc_html__( 'One-Category Portfolio List', 'stockholm-core' ),
                'description' => esc_html__( 'Enter one category slug (leave empty for showing all categories)', 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::TEXT
            ]
        );

        $this->add_control(
            'selected_projects',
            [
                'label' => esc_html__( 'Show Only Projects with Listed IDs', 'stockholm-core' ),
                'description' => esc_html__( 'Delimit ID numbers by comma (leave empty for all)', 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::TEXT
            ]
        );

        $this->add_control(
            'tag',
            [
                'label' => esc_html__( 'One-Tag Portfolio List', 'stockholm-core' ),
                'description' => esc_html__( 'Enter one tag slug (leave empty for showing all tags)', 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::TEXT
            ]
        );

        $this->add_control(
            'orderby',
            [
                'label' => esc_html__( 'Order By', 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => stockholm_qode_get_query_order_by_array(),
                'default' => 'date'
            ]
        );

        $this->add_control(
            'order',
            [
                'label' => esc_html__( 'Order By', 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => stockholm_qode_get_query_order_array(),
                'default' => 'ASC'
            ]
        );

        $this->end_controls_section();
    }

    protected function render(){
        $params = $this->get_settings_for_display();
        $query_array                        = $this->getQueryArray( $params );
        $query_results                      = new \WP_Query( $query_array );
        $params['query_results'] = $query_results;

        $params['holder_classes']    = $this->getHolderClasses( $params );

        $params['custom_element_style'] = $this->getCustomElementStyles( $params );

        $params['this_object'] = $this;

        echo stockholm_qode_get_shortcode_template_part( 'templates/portfolio-holder', 'horizontaly-scrolling-portfolio-list', '', $params );
    }

    public function getQueryArray( $params ) {
        $query_array = array(
            'post_status'    => 'publish',
            'post_type'      => 'portfolio_page',
            'posts_per_page' => $params['number_of_items'],
            'orderby'        => $params['orderby'],
            'order'          => $params['order']
        );

        if ( ! empty( $params['category'] ) ) {
            $query_array['portfolio_category'] = $params['category'];
        }

        $project_ids = null;
        if ( ! empty( $params['selected_projects'] ) ) {
            $project_ids             = explode( ',', $params['selected_projects'] );
            $query_array['post__in'] = $project_ids;
        }

        //exclude featured project
        if ( ! empty( $params['featured_project'] ) ) {
            $query_array['post__not_in'] = array($params['featured_project']);
        }

        if ( ! empty( $params['tag'] ) ) {
            $query_array['portfolio_tag'] = $params['tag'];
        }

        if ( ! empty( $params['next_page'] ) ) {
            $query_array['paged'] = $params['next_page'];
        } else {
            $query_array['paged'] = 1;
        }

        return $query_array;
    }

    public function getHolderClasses( $params ) {
        $classes = array();

        $classes[] = ! empty( $params['featured_project'] ) ? 'qode-hsp-has-featured' : '';

        return implode( ' ', $classes );
    }

    public function getCustomElementStyles( $params ){
        $styles = array();

        if(! empty($params['custom_project_bg_color'])){
            $styles[] = 'background-color: ' . $params['custom_project_bg_color'];
        }

        return implode(';', $styles);
    }

    public function getArticleClasses( $params ) {
        $classes = array();

        $article_classes = get_post_class( $classes );

        return implode( ' ', $article_classes );
    }

    public function getImageSize( $params ) {
        $thumb_size = 'full';

        if ( ! empty( $params['image_proportions'] ) ) {
            $image_size = $params['image_proportions'];

            switch ( $image_size ) {
                case 'landscape':
                    $thumb_size = 'portfolio_masonry_wide';
                    break;
                case 'portrait':
                    $thumb_size = 'portfolio_masonry_tall';
                    break;
                case 'square':
                    $thumb_size = 'portfolio_masonry_large';
                    break;
                case 'medium':
                    $thumb_size = 'medium';
                    break;
                case 'large':
                    $thumb_size = 'large';
                    break;
                case 'full':
                    $thumb_size = 'full';
                    break;
            }
        }

        return $thumb_size;
    }

    public function getItemLink($params) {
        $item_id = $params['is_featured'] ? $params['featured_project'] : get_the_ID();

        $portfolio_link_meta = get_post_meta( $item_id, 'portfolio_external_link', true );
        $portfolio_link      = ! empty( $portfolio_link_meta ) ? $portfolio_link_meta : get_permalink( $item_id );

        return apply_filters( 'stockholm_qode_filter_portfolio_external_link', $portfolio_link );
    }

    public function getItemLinkTarget($params) {
        $item_id = $params['is_featured'] ? $params['featured_project'] : get_the_ID();

        $portfolio_link_meta   = get_post_meta( $item_id, 'portfolio_external_link', true );
        $portfolio_link_target = ! empty( $portfolio_link_meta ) ? '_blank' : '_self';

        return apply_filters( 'stockholm_qode_filter_portfolio_external_link_target', $portfolio_link_target );
    }
}

\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new StockholmCoreHorizontalyScrollingPortfolioList() );