<?php

class StockholmCoreElementorImageMarquee extends \Elementor\Widget_Base {
	
	public function get_name() {
		return 'qode_image_marquee';
	}
	
	public function get_title() {
		return esc_html__( 'Image Marquee', 'stockholm-core' );
	}
	
	public function get_icon() {
		return 'stockholm-elementor-custom-icon stockholm-elementor-image-marquee';
	}
	
	public function get_categories() {
		return [ 'select' ];
	}
	
	protected function _register_controls() {
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'stockholm-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
			'image',
			[
				'label'       => esc_html__( 'Image', 'stockholm-core' ),
				'type'        => \Elementor\Controls_Manager::MEDIA,
				'description' => esc_html__( 'Select image from media library', 'stockholm-core' )
			]
		);
		
		$this->end_controls_section();

        // Add predefined developer tab content for each shortcode element
        $this->start_controls_section(
            'developer_tools',
            [
                'label' => esc_html__( 'Developer Tools', 'stockholm-core' ),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'shortcode_snippet',
            [
                'label'   => esc_html__( 'Show Shortcode Snippet', 'stockholm-core' ),
                'type'    => \Elementor\Controls_Manager::SELECT,
                'default' => 'no',
                'options' => stockholm_qode_get_yes_no_select_array()
            ]
        );

        $this->end_controls_section();
	}
	
	public function render() {
		$params = $this->get_settings_for_display();
		
		$args   = array(
			'image' => '',
		);
		
		if ( ! empty( $params['image'] ) ) {
			$params['image'] = $params['image']['id'];
		}

        if( ! empty( $params['shortcode_snippet'] ) && $params['shortcode_snippet'] == 'yes' ){
            echo $this->get_shortcode_snippet( $params );
        } else{
            echo stockholm_qode_get_shortcode_template_part( 'templates/image-marquee-template', 'image-marquee', '', $params );
        }

    }

    private function get_shortcode_snippet( $params ) {
        $atts = array();

        if ( empty( $this ) || ! is_object( $this ) ) {
            return '';
        }

        if ( ! empty( $params ) ) {
            foreach ( $params as $key => $value ) {
                if ( is_array( $value ) || $key === 'shortcode_snippet' ) {
                    continue;
                }

                if( empty( $value ) || $value == '' ){
                    continue;
                }

                $atts[] = $key . '="' . esc_attr( $value ) . '"';
            }
        }

        return sprintf( '<textarea class="qode-shortcode-snipper-holder" rows="3" readonly>[%s %s]</textarea>',
            'qode_image_marquee',
            implode( ' ', $atts )
        );
    }
}

\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new StockholmCoreElementorImageMarquee() );