<?php

class StockholmCoreElementorImageWithOverlappingInfo extends \Elementor\Widget_Base{
    public function get_name() {
        return 'image_with_overlapping_info';
    }

    public function get_title() {
        return esc_html__('Image With Overlapping Info', 'stockholm-core');
    }

    public function get_icon() {
        return 'stockholm-elementor-custom-icon stockholm-elementor-image-with-overlapping-info';
    }

    public function get_categories() {
        return [ 'select' ];
    }

    protected function _register_controls(){
        $this->start_controls_section(
            'general',
            [
                'label' => esc_html__( 'General', 'stockholm-core' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'image',
            [
                'label' => esc_html__('Image', 'stockholm-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'stockholm-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
            ]
        );
	
	    $this->add_control(
		    'title_tag',
		    [
			    'label' => esc_html__('Title Tag', 'stockholm-core'),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => stockholm_qode_get_title_tag(false),
			    'default' => 'h3'
		    ]
	    );
	
	    $this->add_control(
		    'text',
		    [
			    'label' => esc_html__('Text', 'stockholm-core'),
			    'type' => \Elementor\Controls_Manager::TEXTAREA,
		    ]
	    );
	
	    $this->add_control(
		    'link',
		    [
			    'label' => esc_html__('Link', 'stockholm-core'),
			    'type' => \Elementor\Controls_Manager::TEXT,
		    ]
	    );
	
	    $this->add_control(
		    'link_target',
		    [
			    'label' => esc_html__('Target', 'stockholm-core'),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => stockholm_qode_get_link_target_array()
		    ]
	    );
	
	    $this->add_control(
		    'link_text',
		    [
			    'label' => esc_html__('Link Text', 'stockholm-core'),
			    'type' => \Elementor\Controls_Manager::TEXT,
		    ]
	    );
	
	    $this->add_control(
		    'link_hover_animation',
		    [
			    'label' => esc_html__('Link Hover Animation', 'stockholm-core'),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => [
				    ''             => esc_html__( 'Default', 'stockholm-core' ),
				    'display-dash' => esc_html__( 'Display Dash', 'stockholm-core' )
			    ]
		    ]
	    );

        $this->add_control(
            'link_overlapping_holder',
            [
                'label' => esc_html__('Link Whole Overlapping Holder', 'stockholm-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'no'    => esc_html__('No', 'stockholm-core'),
                    'yes'   => esc_html__('Yes', 'stockholm-core')
                ],
                'default' => 'no'
            ]
        );
	    
        $this->end_controls_section();
    }

    protected function render(){
        $params = $this->get_settings_for_display();

        if( ! empty( $params['image'] ) ){
	        $params['image_src']    = wp_get_attachment_url( $params['image']['id'] );
        }
	    $params['link_classes'] = $this->linkClasses( $params );
        
        echo stockholm_qode_get_shortcode_template_part('templates/image-with-overlapping-info-template', 'image-with-overlapping-info', '', $params);
    }
	
	private function linkClasses( $params ) {
		$classes = array( 'qode-iwoi-link' );
		
		if ( $params['link_hover_animation'] == 'display-dash' ) {
			$classes[] = 'display_dash';
		}
		
		return implode( ' ', $classes );
	}
}

\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new StockholmCoreElementorImageWithOverlappingInfo() );