<?php

if ( ! function_exists( 'stockholm_qode_register_button' ) ) {
	function stockholm_qode_register_button( $buttons ) {
		array_push( $buttons, "|", "qode_shortcodes" );
		
		return $buttons;
	}
}

if ( ! function_exists( 'stockholm_qode_add_shortcode_file' ) ) {
	function stockholm_qode_add_shortcode_file( $plugin_array ) {
		$plugin_array['qode_shortcodes'] = STOCKHOLM_CORE_MODULES_URL_PATH . '/shortcodes/qode_shortcodes.js';
		
		return $plugin_array;
	}
}

if ( ! function_exists( 'stockholm_qode_shortcodes_button' ) ) {
	function stockholm_qode_shortcodes_button() {
		if ( ! current_user_can( 'edit_posts' ) && ! current_user_can( 'edit_pages' ) ) {
			return;
		}
		
		if ( get_user_option( 'rich_editing' ) == 'true' ) {
			add_filter( 'mce_external_plugins', 'stockholm_qode_add_shortcode_file' );
			add_filter( 'mce_buttons', 'stockholm_qode_register_button' );
		}
	}
	
	add_action( 'after_setup_theme', 'stockholm_qode_shortcodes_button' );
}

if ( ! function_exists( 'stockholm_qode_get_shortcode_template_part' ) ) {
	/**
	 * Loads module template part.
	 *
	 * @param string $template name of the template to load
	 * @param string $shortcode name of the shortcode folder
	 * @param string $slug
	 * @param array  $params array of parameters to pass to template
	 *
	 * @return html
	 * @see stockholm_qode_get_template_part()
	 */
	function stockholm_qode_get_shortcode_template_part( $template, $shortcode, $slug = '', $params = array() ) {
		
		//HTML Content from template
		$html          = '';
		$template_path = STOCKHOLM_CORE_SHORTCODES_ROOT_DIR . '/' . $shortcode;
		
		$temp = $template_path . '/' . $template;
		if ( is_array( $params ) && count( $params ) ) {
			extract( $params );
		}
		
		$template = '';
		
		if ( ! empty( $temp ) ) {
			if ( ! empty( $slug ) ) {
				$template = "{$temp}-{$slug}.php";
				
				if ( ! file_exists( $template ) ) {
					$template = $temp . '.php';
				}
			} else {
				$template = $temp . '.php';
			}
		}
		
		$template = apply_filters( 'stockholm_qode_filter_shortcode_template_part', $template );
		
		if ( $template ) {
			ob_start();
			include( $template );
			$html = ob_get_clean();
		}
		
		return $html;
	}
}

include_once STOCKHOLM_CORE_SHORTCODES_ROOT_DIR . '/_accordion/accordion.php';
include_once STOCKHOLM_CORE_SHORTCODES_ROOT_DIR . '/_blockquote/blockquote.php';
include_once STOCKHOLM_CORE_SHORTCODES_ROOT_DIR . '/_button/button.php';
include_once STOCKHOLM_CORE_SHORTCODES_ROOT_DIR . '/_call-to-action/call-to-action.php';
include_once STOCKHOLM_CORE_SHORTCODES_ROOT_DIR . '/_countdown/countdown.php';
include_once STOCKHOLM_CORE_SHORTCODES_ROOT_DIR . '/_counter/counter.php';
include_once STOCKHOLM_CORE_SHORTCODES_ROOT_DIR . '/_cover-boxes/cover-boxes.php';
include_once STOCKHOLM_CORE_SHORTCODES_ROOT_DIR . '/_custom-font/custom-font.php';
include_once STOCKHOLM_CORE_SHORTCODES_ROOT_DIR . '/dropcaps.php';
include_once STOCKHOLM_CORE_SHORTCODES_ROOT_DIR . '/highlights.php';
include_once STOCKHOLM_CORE_SHORTCODES_ROOT_DIR . '/_icon/icon.php';
include_once STOCKHOLM_CORE_SHORTCODES_ROOT_DIR . '/_icon-list-item/icon-list-item.php';
include_once STOCKHOLM_CORE_SHORTCODES_ROOT_DIR . '/_icon-with-text/icon-with-text.php';
include_once STOCKHOLM_CORE_SHORTCODES_ROOT_DIR . '/_image-hover/image-hover.php';
include_once STOCKHOLM_CORE_SHORTCODES_ROOT_DIR . '/_image-slider/image-slider.php';
include_once STOCKHOLM_CORE_SHORTCODES_ROOT_DIR . '/_image-with-text/image-with-text.php';
include_once STOCKHOLM_CORE_SHORTCODES_ROOT_DIR . '/_interactive-banners/interactive-banners.php';
include_once STOCKHOLM_CORE_SHORTCODES_ROOT_DIR . '/_latest-posts/latest-posts.php';
include_once STOCKHOLM_CORE_SHORTCODES_ROOT_DIR . '/_line-graph/line-graph.php';
include_once STOCKHOLM_CORE_SHORTCODES_ROOT_DIR . '/_message/message.php';
include_once STOCKHOLM_CORE_SHORTCODES_ROOT_DIR . '/_ordered-list/ordered-list.php';
include_once STOCKHOLM_CORE_SHORTCODES_ROOT_DIR . '/_pie-chart/pie-chart.php';
include_once STOCKHOLM_CORE_SHORTCODES_ROOT_DIR . '/_pie-chart-doughnut/pie-chart-doughnut.php';
include_once STOCKHOLM_CORE_SHORTCODES_ROOT_DIR . '/_pie-chart-full/pie-chart-full.php';
include_once STOCKHOLM_CORE_SHORTCODES_ROOT_DIR . '/_pie-chart-with-icon/pie-chart-with-icon.php';
include_once STOCKHOLM_CORE_SHORTCODES_ROOT_DIR . '/_portfolio-slider/portfolio-slider.php';
include_once STOCKHOLM_CORE_SHORTCODES_ROOT_DIR . '/_product-categories-showcase/product-categories-showcase.php';
include_once STOCKHOLM_CORE_SHORTCODES_ROOT_DIR . '/_product-list/product-list.php';
include_once STOCKHOLM_CORE_SHORTCODES_ROOT_DIR . '/_progress-bar/progress-bar.php';
include_once STOCKHOLM_CORE_SHORTCODES_ROOT_DIR . '/_progress-bar-icon/progress-bar-icon.php';
include_once STOCKHOLM_CORE_SHORTCODES_ROOT_DIR . '/_progress-bar-vertical/progress-bar-vertical.php';
include_once STOCKHOLM_CORE_SHORTCODES_ROOT_DIR . '/_qode-carousel/qode-carousel.php';
include_once STOCKHOLM_CORE_SHORTCODES_ROOT_DIR . '/qode-slider.php';
include_once STOCKHOLM_CORE_SHORTCODES_ROOT_DIR . '/_service-table/service-table.php';
include_once STOCKHOLM_CORE_SHORTCODES_ROOT_DIR . '/_social-icon/social-icon.php';
include_once STOCKHOLM_CORE_SHORTCODES_ROOT_DIR . '/_social-share/social-share.php';
include_once STOCKHOLM_CORE_SHORTCODES_ROOT_DIR . '/_social-share-list/social-share-list.php';
include_once STOCKHOLM_CORE_SHORTCODES_ROOT_DIR . '/_team/team.php';
include_once STOCKHOLM_CORE_SHORTCODES_ROOT_DIR . '/_testimonials/testimonials.php';
include_once STOCKHOLM_CORE_SHORTCODES_ROOT_DIR . '/_unordered-list/unordered-list.php';

//shortcodes v2
if ( ! function_exists( 'stockholm_qode_load_shortcode_interface' ) ) {
	function stockholm_qode_load_shortcode_interface() {
		include_once STOCKHOLM_CORE_MODULES_PATH . '/shortcodes/lib/shortcode-interface.php';
	}
	
	add_action( 'stockholm_qode_action_before_options_map', 'stockholm_qode_load_shortcode_interface' );
}

if ( ! function_exists( 'stockholm_qode_load_shortcodes' ) ) {
	/**
	 * Loades all shortcodes by going through all folders that are placed directly in shortcodes/shortcode-elements folder
	 * and loads load.php file in each. Hooks to stockholm_qode_action_before_options_map action
	 *
	 * @see http://php.net/manual/en/function.glob.php
	 */
	function stockholm_qode_load_shortcodes() {
		foreach ( glob( STOCKHOLM_CORE_SHORTCODES_ROOT_DIR . '/*/load.php' ) as $shortcode_load ) {
			include_once $shortcode_load;
		}
		
		do_action( 'stockholm_qode_action_include_shortcodes_file' );
		
		include_once STOCKHOLM_CORE_MODULES_PATH . '/shortcodes/lib/shortcode-loader.php';
	}
	
	add_action( 'stockholm_qode_action_before_options_map', 'stockholm_qode_load_shortcodes' );
}

//Load Elementor Shortcodes
if( ! function_exists('stockholm_core_load_elementor_shortcodes') ){
	function stockholm_core_load_elementor_shortcodes(){
		if( stockholm_core_is_installed('elementor') ) {
			foreach (glob(STOCKHOLM_CORE_MODULES_PATH . '/shortcodes/shortcode-elements/*/elementor-*.php') as $shortcode_load) {
				include_once $shortcode_load;
			}
		}
	}
	
	add_action('elementor/widgets/widgets_registered', 'stockholm_core_load_elementor_shortcodes');
}

if( ! function_exists('stockholm_core_add_elementor_widget_categories') ) {
	function stockholm_core_add_elementor_widget_categories($elements_manager) {
		
		$elements_manager->add_category(
			'select',
			[
				'title' => esc_html__('by SELECT', 'stockholm-core'),
				'icon' => 'fa fa-plug',
			]
		);
		
	}
	
	add_action('elementor/elements/categories_registered', 'stockholm_core_add_elementor_widget_categories');
};

if( ! function_exists('stockholm_core_elementor_icons_style') ){
	function stockholm_core_elementor_icons_style(){
		wp_enqueue_style( 'stockholm-core-elementor', STOCKHOLM_CORE_MODULES_URL_PATH . '/shortcodes/assets/css/elementor.css');
	}
	
	add_action( 'elementor/editor/before_enqueue_scripts', 'stockholm_core_elementor_icons_style' );
}

//function that returns all Elementor saved templates
if( ! function_exists('stockholm_core_return_elementor_templates') ){
	function stockholm_core_return_elementor_templates(){
		return Elementor\Plugin::instance()->templates_manager->get_source( 'local' )->get_items();
	}
}

//function that adds Template Elementor Control
if( ! function_exists('stockholm_core_generate_elementor_templates_control') ){
	function stockholm_core_generate_elementor_templates_control( $object, $dependency_array = array() , $control_name = 'template_id' ){
		$templates = stockholm_core_return_elementor_templates();
		
		if ( ! empty( $templates ) ) {
			$options = [
				'0' => '— ' . esc_html__('Select', 'stockholm-core') . ' —',
			];
			
			$types = [];
			
			foreach ($templates as $template) {
				$options[$template['template_id']] = $template['title'] . ' (' . $template['type'] . ')';
				$types[$template['template_id']] = $template['type'];
			}
			
			$control_options_array = [
				'label' => esc_html__('Choose Template', 'stockholm-core'),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => '0',
				'options' => $options,
				'types' => $types,
				'label_block' => 'true'
			];
			
			if( is_array( $dependency_array ) && count( $dependency_array ) > 0 ){
				$control_options_array['condition'] = $dependency_array;
			}
			
			$object->add_control(
				$control_name, $control_options_array
			);
		};
	}
}

//function that maps "Anchor" option for section
if( ! function_exists('stockholm_core_map_section_anchor_option') ){
	function stockholm_core_map_section_anchor_option( $section, $args ){
		$section->start_controls_section(
			'section_qode_anchor',
			[
				'label' => esc_html__( 'Stockholm Anchor', 'stockholm-core' ),
				'tab' => \Elementor\Controls_Manager::TAB_ADVANCED,
			]
		);
		
		$section->add_control(
			'anchor_id',
			[
				'label'        => esc_html__( 'Stockholm Anchor ID', 'stockholm-core' ),
				'type'         => Elementor\Controls_Manager::TEXT,
			]
		);
		
		$section->end_controls_section();
	}
	
	add_action('elementor/element/section/_section_responsive/after_section_end', 'stockholm_core_map_section_anchor_option', 10, 2);
}

//function that renders "Anchor" option for section
if( ! function_exists('stockholm_core_render_section_anchor_option') ) {
	function stockholm_core_render_section_anchor_option( $element )   {
		if( 'section' !== $element->get_name() ) {
			return;
		}
		
		$params = $element->get_settings_for_display();
		
		if( ! empty( $params['anchor_id'] ) ){
			$element->add_render_attribute( '_wrapper', 'data-q_id', '#' . $params['anchor_id'] );
		}
	}
	
	add_action( 'elementor/frontend/section/before_render', 'stockholm_core_render_section_anchor_option');
}


//function that maps "Parallax" option for section
if( ! function_exists('stockholm_core_map_section_parallax_option') ){
	function stockholm_core_map_section_parallax_option( $section, $args ){
		$section->start_controls_section(
			'section_qode_parallax',
			[
				'label' => esc_html__( 'Stockholm Parallax', 'stockholm-core' ),
				'tab' => \Elementor\Controls_Manager::TAB_ADVANCED,
			]
		);
		
		$section->add_control(
			'qode_enable_parallax',
			[
				'label'        => esc_html__( 'Enable Parallax', 'stockholm-core'),
				'type'         => Elementor\Controls_Manager::SELECT,
				'default'      => 'no',
				'options' => [
					'no' => esc_html__('No', 'stockholm-core')  ,
					'holder' => esc_html__('Yes', 'stockholm-core')  ,
				],
				'prefix_class' => 'parallax_section_'
			]
		);
		
		$section->add_control(
			'qode_parallax_image',
			[
				'label'        => esc_html__( 'Parallax Image', 'stockholm-core' ),
				'type'         => Elementor\Controls_Manager::MEDIA,
				'condition' => [
					'qode_enable_parallax' => 'holder'
				],
				'frontend_available' => true,
				'selectors' => [
					'{{WRAPPER}}.parallax_section_holder' => 'background-image: url("{{URL}}") !important;'
				]
			]
		);
		
		$section->add_control(
			'qode_parallax_speed',
			[
				'label'        => esc_html__( 'Parallax Speed', 'stockholm-core' ),
				'type'         => Elementor\Controls_Manager::TEXT,
				'condition' => [
					'qode_enable_parallax' => 'holder'
				],
				'default' => '0'
			]
		);
		
		$section->end_controls_section();
	}
	
	add_action('elementor/element/section/_section_responsive/after_section_end', 'stockholm_core_map_section_parallax_option', 10, 2);
}

//function that renders "Anchor" option for section
if( ! function_exists('stockholm_core_render_section_parallax_option') ) {
	function stockholm_core_render_section_parallax_option( $element )   {
		if( 'section' !== $element->get_name() ) {
			return;
		}
		
		$params = $element->get_settings_for_display();
		
		if( ! empty( $params['qode_parallax_image']['id'] ) ){
			$parallax_image_src = $params['qode_parallax_image']['url'];
			$parallax_speed = ! empty( $params['qode_parallax_speed'] ) ? $params['qode_parallax_speed'] : '0';
			
			$element->add_render_attribute( '_wrapper', 'style', 'background-image: url(' . $parallax_image_src . ');' );
			$element->add_render_attribute( '_wrapper', 'class', 'parallax_section_holder' );
			$element->add_render_attribute( '_wrapper', 'data-speed', $parallax_speed );
		}
	}
	
	add_action( 'elementor/frontend/section/before_render', 'stockholm_core_render_section_parallax_option');
}

//function that renders helper hidden input for parallax data attribute section
if( ! function_exists('stockholm_core_generate_parallax_helper') ){
	function stockholm_core_generate_parallax_helper( $template, $widget ){
		if ( 'section' === $widget->get_name() ) {
			$template_preceding = "
            <# if( settings.qode_enable_parallax == 'holder' ){
		        let parallaxSpeed = settings.qode_parallax_speed !== '' ? settings.qode_parallax_speed : '0'; #>
		        <input type='hidden' class='qode-parallax-helper-holder' data-speed='{{ parallaxSpeed }}'/>
		    <# } #>";
			$template = $template_preceding . " " . $template;
		}
		
		return $template;
	}
	
	add_action( 'elementor/section/print_template', 'stockholm_core_generate_parallax_helper', 10, 2 );
}

//function that maps "Full Screen Sections" option for section
if( ! function_exists('stockholm_core_map_grid_option') ){
	function stockholm_core_map_grid_option( $section, $args ){
		$section->start_controls_section(
			'section_qode_grid_row',
			[
				'label' => esc_html__( 'Stockholm Grid', 'stockholm-core' ),
				'tab' => \Elementor\Controls_Manager::TAB_ADVANCED,
			]
		);
		
		$section->add_control(
			'qode_enable_grid_row',
			[
				'label'        => esc_html__( 'Make this row "In Grid"', 'stockholm-core'),
				'type'         => Elementor\Controls_Manager::SELECT,
				'default'      => 'no',
				'options' => [
					'no' => esc_html__('No', 'stockholm-core')  ,
					'inner' => esc_html__('Yes', 'stockholm-core')  ,
				],
				'prefix_class' => 'qode_elementor_container_'
			]
		);
		
		$section->end_controls_section();
	}
	
	add_action('elementor/element/section/_section_responsive/after_section_end', 'stockholm_core_map_grid_option', 10, 2);
}

//function that maps "Content Alignment" option for section
if ( ! function_exists( 'stockholm_core_map_section_content_alignment_option' ) ) {
    function stockholm_core_map_section_content_alignment_option( $section, $args ) {
        $section->start_controls_section(
            'qode_section_content_alignment',
            [
                'label' => esc_html__( 'Stockholm Content Alignment', 'stockholm-core' ),
                'tab'   => \Elementor\Controls_Manager::TAB_ADVANCED,
            ]
        );

        $section->add_control(
            'qode_content_alignment',
            [
                'label'        => esc_html__( 'Content Alignment', 'stockholm-core' ),
                'type'         => Elementor\Controls_Manager::SELECT,
                'default'      => 'left',
                'options'      => [
                    'left'   => esc_html__( 'Left', 'stockholm-core' ),
                    'center' => esc_html__( 'Center', 'stockholm-core' ),
                    'right'  => esc_html__( 'Right', 'stockholm-core' )
                ],
                'prefix_class' => 'qode-content-aligment-'
            ]
        );

        $section->end_controls_section();
    }

    add_action( 'elementor/element/section/_section_responsive/after_section_end', 'stockholm_core_map_section_content_alignment_option', 10, 2 );
}

if( ! function_exists('stockholm_core_elementor_icons_style') ){
	function stockholm_core_elementor_icons_style(){
		wp_enqueue_style( 'stockholm-core-elementor', STOCKHOLM_CORE_URL_PATH . '/modules/shortcodes/assets/css/elementor.css');
	}
	
	add_action( 'elementor/editor/before_enqueue_scripts', 'stockholm_core_elementor_icons_style' );
}