<?php
/*
Plugin Name: Stockholm Core
Description: Plugin that adds additional features needed by our theme
Author: Select Themes
Version: 2.1.9
*/
if ( ! class_exists( 'StockholmCore' ) ) {
	class StockholmCore {
		private static $instance;
		
		public function __construct() {
			require_once 'constants.php';
			require_once 'helpers/helper.php';
			
			// Make plugin available for translation
			add_action( 'plugins_loaded', array( $this, 'load_plugin_textdomain' ) );
			
			// Add plugin's body classes
			add_filter( 'body_class', array( $this, 'add_body_classes' ) );

            add_action( 'admin_menu', array( $this, 'stockholm_theme_menu' ) );
			
			add_action( 'after_setup_theme', array( $this, 'init' ), 5 );
		}

        public static function get_instance() {
            if ( ! isset( self::$instance ) && ! ( self::$instance instanceof self ) ) {
                self::$instance = new self();
            }

            return self::$instance;
        }
		
		function load_plugin_textdomain() {
			load_plugin_textdomain( 'stockholm-core', false, STOCKHOLM_CORE_REL_PATH . '/languages' );
		}
		
		function add_body_classes( $classes ) {
			$classes[] = 'stockholm-core-' . STOCKHOLM_CORE_VERSION;
			
			return $classes;
		}
		
		function init() {
			
			if ( stockholm_core_is_installed( 'theme' ) ) {
				include_once STOCKHOLM_CORE_MODULES_PATH . '/helper.php';
			}
		}

        function stockholm_theme_menu() {
		    if( stockholm_core_is_installed('theme') ) {
                global $stockholm_qode_framework;
                stockholm_qode_init_theme_options();

                $page_hook_suffix = add_menu_page(
                    esc_html__('Select Options', 'stockholm'),                   // The value used to populate the browser's title bar when the menu page is active
                    esc_html__('Select Options', 'stockholm'),                   // The text of the menu in the administrator's sidebar
                    'administrator',                  // What roles are able to access the menu
                    'qode_theme_menu',                // The ID used to bind submenu items to this menu
                    'stockholm_qode_theme_display',              // The callback function used to render this menu
                    QODE_FRAMEWORK_ROOT . '/admin/assets/img/admin-logo-icon.png',
                    4
                );

                foreach ($stockholm_qode_framework->qodeOptions->adminPages as $key => $value) {
                    $slug = "";
                    if (!empty($value->slug)) {
                        $slug = "_tab" . $value->slug;
                    }

                    $subpage_hook_suffix = add_submenu_page(
                        'qode_theme_menu',
                        sprintf(esc_html__('Select Options - %s', 'stockholm'), esc_attr($value->title)),                   // The value used to populate the browser's title bar when the menu page is active
                        $value->title,                   // The text of the menu in the administrator's sidebar
                        'administrator',                  // What roles are able to access the menu
                        'qode_theme_menu' . $slug,                // The ID used to bind submenu items to this menu
                        'stockholm_qode_theme_display'              // The callback function used to render this menu
                    );

                    add_action('admin_print_scripts-' . $subpage_hook_suffix, 'stockholm_qode_enqueue_admin_scripts');
                    add_action('admin_print_styles-' . $subpage_hook_suffix, 'stockholm_qode_enqueue_admin_styles');
                };

                add_action('admin_print_scripts-' . $page_hook_suffix, 'stockholm_qode_enqueue_admin_scripts');
                add_action('admin_print_styles-' . $page_hook_suffix, 'stockholm_qode_enqueue_admin_styles');
            }
        }
	}
	
	StockholmCore::get_instance();
}
