<?php

class SelectTwitterFeedElementorSelectTwitter extends \Elementor\Widget_Base{
    public function get_name() {
        return 'select_twitter_shortcode';
    }

    public function get_title() {
        return esc_html__( 'Select Twitter Feed', 'select-twitter-feed' );
    }

    public function get_icon() {
        return 'stockholm-elementor-custom-icon stockholm-elementor-select-twitter';
    }

    public function get_categories() {
        return [ 'select' ];
    }

    protected function _register_controls(){

        $this->start_controls_section(
            'general',
            [
                'label' => esc_html__( 'General', 'select-twitter-feed' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        
        $this->add_control(
            'user_id',
            [
                'label' => esc_html__('User ID', 'select-twitter-feed'),
                'type' => \Elementor\Controls_Manager::TEXT
            ]
        );
        
        $this->add_control(
            'count',
            [
                'label' => esc_html__('Number of Tweets', 'select-twitter-feed'),
                'type' => \Elementor\Controls_Manager::TEXT,
            ]
        );

        $this->add_control(
            'show_tweet_time',
            [
                'label' => esc_html__('Show Tweet Time', 'select-twitter-feed'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'no'    => esc_html__( 'No', 'select-twitter-feed' ),
                    'yes'   => esc_html__( 'Yes', 'select-twitter-feed' ),
                ],
                'default' => 'no'
            ]
        );

	    $this->add_control(
		    'transient_time',
		    [
			    'label' => esc_html__('Tweets Cache Time', 'select-twitter-feed'),
			    'type' => \Elementor\Controls_Manager::TEXT,
		    ]
	    );

	    $this->add_control(
		    'feed_id',
		    [
			    'label' => esc_html__('Twitter Feed ID', 'select-twitter-feed'),
			    'type' => \Elementor\Controls_Manager::TEXT,
		    ]
	    );

	    $this->add_control(
		    'show_navigation',
		    [
			    'label' => esc_html__('Show navigation bullets', 'select-twitter-feed'),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => [
				    'yes'       => esc_html__( 'Yes', 'select-twitter-feed' ),
				    'no'        => esc_html__( 'No', 'select-twitter-feed' )
			    ],
			    'default' => 'yes'
		    ]
	    );

	    $this->add_control(
		    'show_arrows',
		    [
			    'label' => esc_html__('Show navigation arrows', 'select-twitter-feed'),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => [
				    'yes'       => esc_html__( 'Yes', 'select-twitter-feed' ),
				    'no'        => esc_html__( 'No', 'select-twitter-feed' )
			    ],
			    'default' => 'yes'
		    ]
	    );

	    $this->add_control(
		    'auto_rotate_slides',
		    [
			    'label' => esc_html__('Auto rotate slides', 'select-twitter-feed'),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => [
				    '3'         => esc_html__( '3', 'select-twitter-feed' ),
				    '5'         => esc_html__( '5', 'select-twitter-feed' ),
				    '10'        => esc_html__( '10', 'select-twitter-feed' ),
				    '15'        => esc_html__( '15', 'select-twitter-feed' ),
				    '0'        => esc_html__( 'Disable', 'select-twitter-feed' ),
			    ],
			    'default' => '3'
		    ]
	    );
	
	    $this->add_control(
		    'animation_type',
		    [
			    'label' => esc_html__('Animation type', 'select-twitter-feed'),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => [
				    'fade'   => esc_html__( 'Fade', 'select-twitter-feed' ),
				    'slide'  => esc_html__( 'Slide', 'select-twitter-feed' )
			    ],
			    'default' => 'fade'
		    ]
	    );

	    $this->add_control(
		    'animation_speed',
		    [
			    'label' => esc_html__('Animation speed', 'select-twitter-feed'),
			    'type' => \Elementor\Controls_Manager::TEXT,
		    ]
	    );

	    $this->end_controls_section();
        
    }

    protected function render(){
	    $args = array(
		    "user_id"               => "",
		    "count"                 => "",
		    "show_tweet_time"       => "no",
		    "transient_time"        => "",
		    "feed_id"               => "",
		    "show_navigation"       => "",
		    "show_arrows"           => "",
		    "auto_rotate_slides"    => "",
		    "animation_type"        => "",
		    "animation_speed"       => ""
	    );
    	$atts = $this->get_settings_for_display();
    	
	    extract(shortcode_atts($args, $atts));
	    $shortcode_id =
	    $html = "";

	    $user_id = !empty($user_id) ? $user_id : '';
	    $count = !empty($count) ? $count : '';
	    $transient_time = !empty($transient_time) ? $transient_time : 0;
	    $feed_id = !empty($feed_id) ? $feed_id : rand();

	    $twitter_api = StockholmQodeTwitterApi::getInstance();

	    if($twitter_api->hasUserConnected()) {
		    $response = $twitter_api->fetchTweets($user_id, $count, array(
			    'transient_time' => $transient_time,
			    'transient_id' => 'qode_twitter_'.$feed_id
		    ));

		    if($response->status) {
			    if(is_array($response->data) && count($response->data)) { ?>
				    <div class="qode_twitter_shortcode twitter_carousel" data-show-navigation="<?php echo esc_attr($show_navigation) ?>" data-show-arrows="<?php echo esc_attr($show_arrows) ?>" data-animation-type="<?php echo esc_attr($animation_type) ?>" data-animation-speed="<?php echo esc_attr($animation_speed) ?>" data-auto-rotate-slides="<?php echo esc_attr($auto_rotate_slides) ?>">
					    <ul class="slides">
						    <?php foreach($response->data as $tweet) { ?>
							    <li>
								    <div class="grid_section"><div class="section_inner">
										    <div class="qode_twitter_holder">
											    <div class="tweet_icon_holder">
												    <span class="social_twitter"></span>
											    </div>
											    <div class="tweet_content_holder">
												    <div class="qode_tweet_text_holder">
													    <div class="qode_tweet_text">
														    <?php echo wp_kses_post($twitter_api->getHelper()->getTweetText($tweet)); ?>
													    </div>
													    <?php if($show_tweet_time == 'yes') { ?>
														    <div class="qode_tweet_time">
															    <a target="_blank" href="<?php echo esc_url($twitter_api->getHelper()->getTweetURL($tweet)); ?>">
																    <?php echo wp_kses_post($twitter_api->getHelper()->getTweetTime($tweet)); ?>
															    </a>
														    </div>
													    <?php } ?>
												    </div>
												    <div class="qode_tweet_author">
													    &ndash;<?php echo esc_html($twitter_api->getHelper()->getTweetUserName($tweet)); ?>
													    (<a target="_blank" href="<?php echo esc_url('https://twitter.com/'.$twitter_api->getHelper()->getTweetUserScreenName($tweet)); ?>">@<?php echo esc_html($twitter_api->getHelper()->getTweetUserScreenName($tweet)); ?></a>)
												    </div>
											    </div>
										    </div>
									    </div></div>
							    </li>
						    <?php } ?>
					    </ul>
				    </div>
			    <?php }
		    } else {
			    echo esc_html($response->message);
		    }
	    } else {
		    esc_html_e('It seams that you haven\'t connected with your Twitter account','select-twitter-feed');
	    }

	    echo $html;

    }
}

\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new SelectTwitterFeedElementorSelectTwitter() );